package org.me;

import java.util.Date;

import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.naming.InitialContext;

@MessageDriven(activationConfig = {
		@ActivationConfigProperty(propertyName = "destinationType", propertyValue = "javax.jms.Queue"),
		@ActivationConfigProperty(propertyName = "destination", propertyValue = "java:/jms/queue/TaskQueue, java:jboss/exported/TaskQueue") })
public class TaskProcessor2 implements MessageListener {
	private String VERSION = "1.1";
	@Override
	public void onMessage(Message message) {
		try {
			if (message instanceof MapMessage) {
				System.out.println("Az zenet ekkor megrkezett (TaskGenerator1): " + new Date());
				MapMessage msg = (MapMessage) message;
				System.out.println("Az zenet verzija: " + msg.getString("version"));
				if(!VERSION.equals(msg.getString("version"))) {
					sendMessage(message, "java:/jms/queue/InvalidQueue");
					return;
				}
				System.out.println("zenet feldolgozva.");
			} else {
				System.out.println("hibs zenet");
			}
		} catch (JMSException e) {
			e.printStackTrace();
		}
	}
	
	private void sendMessage(Message message, String queueName) {
		InitialContext initialContext = null;
		try {
			initialContext = new InitialContext();
			QueueConnectionFactory qconFactory = (QueueConnectionFactory) initialContext
					.lookup("java:jboss/DefaultJMSConnectionFactory");
			QueueConnection qcon = qconFactory.createQueueConnection();
			QueueSession qsession = qcon.createQueueSession(false, Session.AUTO_ACKNOWLEDGE);
			Queue queue = (Queue) initialContext.lookup(queueName);
			QueueSender qsender = qsession.createSender(queue);
			qcon.start();
			qsender.send(message);
			qsender.close();
			qsession.close();
			qcon.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}