/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.behavior.confirm;

import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import org.primefaces.behavior.base.AbstractBehavior;
import org.primefaces.behavior.base.BehaviorAttribute;
import org.primefaces.component.api.Confirmable;
import org.primefaces.shaded.json.JSONObject;

public class ConfirmBehavior
extends AbstractBehavior {
    public static final String BEHAVIOR_ID = "org.primefaces.behavior.ConfirmBehavior";

    public String getScript(ClientBehaviorContext behaviorContext) {
        FacesContext context = behaviorContext.getFacesContext();
        UIComponent component = behaviorContext.getComponent();
        if (this.isDisabled()) {
            if (component instanceof Confirmable) {
                ((Confirmable)component).setConfirmationScript(null);
            }
            return null;
        }
        String source = component.getClientId(context);
        String type = JSONObject.quote(this.getType());
        String headerText = JSONObject.quote(this.getHeader());
        String messageText = JSONObject.quote(this.getMessage());
        String beforeShow = JSONObject.quote(this.getBeforeShow());
        if (component instanceof Confirmable) {
            String sourceProperty = source == null ? "source:this" : "source:\"" + source + "\"";
            String script = "PrimeFaces.confirm({" + sourceProperty + ",type:" + type + ",escape:" + this.isEscape() + ",header:" + headerText + ",message:" + messageText + ",icon:\"" + this.getIcon() + "\",beforeShow:" + beforeShow + "});return false;";
            ((Confirmable)component).setConfirmationScript(script);
            return null;
        }
        throw new FacesException("Component " + source + " is not a Confirmable. ConfirmBehavior can only be attached to components that implement " + Confirmable.class.getName() + " interface");
    }

    @Override
    protected BehaviorAttribute[] getAllAttributes() {
        return PropertyKeys.values();
    }

    public String getType() {
        return this.eval(PropertyKeys.type, "dialog");
    }

    public void setType(String type) {
        this.put(PropertyKeys.type, (Object)type);
    }

    public String getHeader() {
        return this.eval(PropertyKeys.header, null);
    }

    public void setHeader(String header) {
        this.put(PropertyKeys.header, (Object)header);
    }

    public String getMessage() {
        return this.eval(PropertyKeys.message, null);
    }

    public void setMessage(String message) {
        this.put(PropertyKeys.message, (Object)message);
    }

    public String getIcon() {
        return this.eval(PropertyKeys.icon, null);
    }

    public void setIcon(String icon) {
        this.put(PropertyKeys.icon, (Object)icon);
    }

    public boolean isDisabled() {
        return this.eval(PropertyKeys.disabled, Boolean.FALSE);
    }

    public void setDisabled(boolean disabled) {
        this.put(PropertyKeys.disabled, (Object)disabled);
    }

    public String getBeforeShow() {
        return this.eval(PropertyKeys.beforeShow, null);
    }

    public void setBeforeShow(String beforeShow) {
        this.put(PropertyKeys.beforeShow, (Object)beforeShow);
    }

    public boolean isEscape() {
        return this.eval(PropertyKeys.escape, Boolean.TRUE);
    }

    public void setEscape(boolean escape) {
        this.put(PropertyKeys.escape, (Object)escape);
    }

    public static enum PropertyKeys implements BehaviorAttribute
    {
        type(String.class),
        header(String.class),
        message(String.class),
        icon(String.class),
        disabled(Boolean.class),
        beforeShow(String.class),
        escape(Boolean.class);

        private final Class<?> expectedType;

        private PropertyKeys(Class<?> expectedType) {
            this.expectedType = expectedType;
        }

        @Override
        public Class<?> getExpectedType() {
            return this.expectedType;
        }
    }
}

