/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.fileupload;

import javax.el.MethodExpression;
import javax.faces.application.FacesMessage;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.validator.ValidatorException;
import org.primefaces.component.fileupload.FileUploadBase;
import org.primefaces.event.FileUploadEvent;
import org.primefaces.event.FilesUploadEvent;
import org.primefaces.model.file.UploadedFile;
import org.primefaces.model.file.UploadedFiles;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.FileUploadUtils;
import org.primefaces.virusscan.VirusException;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="fileupload/fileupload.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js"), @ResourceDependency(library="primefaces", name="fileupload/fileupload.js")})
public class FileUpload
extends FileUploadBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.FileUpload";
    public static final String CONTAINER_CLASS = "ui-fileupload ui-widget ui-fileupload-responsive";
    public static final String BUTTON_BAR_CLASS = "ui-fileupload-buttonbar ui-widget-header ui-corner-top";
    public static final String CONTENT_CLASS = "ui-fileupload-content ui-widget-content ui-corner-bottom";
    public static final String FILES_CLASS = "ui-fileupload-files";
    public static final String CHOOSE_BUTTON_CLASS = "ui-fileupload-choose";
    public static final String UPLOAD_BUTTON_CLASS = "ui-fileupload-upload";
    public static final String CANCEL_BUTTON_CLASS = "ui-fileupload-cancel";
    public static final String BUTTON_ICON_ONLY = "ui-fileupload-icon-only";
    public static final String CONTAINER_CLASS_SIMPLE = "ui-fileupload-simple ui-widget";
    public static final String FILENAME_CLASS = "ui-fileupload-filename";

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        MethodExpression me;
        super.broadcast(event);
        FacesContext facesContext = this.getFacesContext();
        if ((event instanceof FileUploadEvent || event instanceof FilesUploadEvent) && (me = this.getListener()) != null) {
            me.invoke(facesContext.getELContext(), new Object[]{event});
        }
    }

    protected void validateValue(FacesContext context, Object newValue) {
        super.validateValue(context, newValue);
        if (this.isValid() && ComponentUtils.isRequestSource((UIComponent)this, context)) {
            try {
                if (newValue instanceof UploadedFile) {
                    FileUploadUtils.tryValidateFile(context, this, (UploadedFile)newValue);
                } else if (newValue instanceof UploadedFiles) {
                    FileUploadUtils.tryValidateFiles(context, this, ((UploadedFiles)newValue).getFiles());
                } else {
                    throw new IllegalArgumentException("Argument of type '" + newValue.getClass().getName() + "' not supported");
                }
                if (newValue instanceof UploadedFile) {
                    this.queueEvent(new FileUploadEvent((UIComponent)this, (UploadedFile)newValue));
                } else if (newValue instanceof UploadedFiles) {
                    this.queueEvent(new FilesUploadEvent((UIComponent)this, (UploadedFiles)newValue));
                }
            }
            catch (ValidatorException | VirusException e) {
                this.setValid(false);
                context.addMessage(this.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, e.getMessage(), null));
            }
        }
    }
}

