/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.galleria;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.galleria.Galleria;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class GalleriaRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Galleria galleria = (Galleria)component;
        this.encodeMarkup(context, (UIComponent)galleria);
        this.encodeScript(context, (UIComponent)galleria);
    }

    public void encodeMarkup(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Galleria galleria = (Galleria)component;
        String var = galleria.getVar();
        String style = galleria.getStyle();
        String styleClass = galleria.getStyleClass();
        styleClass = styleClass == null ? "ui-galleria ui-widget ui-widget-content ui-corner-all" : "ui-galleria ui-widget ui-widget-content ui-corner-all " + styleClass;
        UIComponent content = galleria.getFacet("content");
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)galleria.getClientId(context), "id");
        writer.writeAttribute("tabindex", (Object)galleria.getTabindex(), null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.startElement("ul", component);
        writer.writeAttribute("class", (Object)"ui-galleria-panel-wrapper", null);
        if (var == null) {
            for (UIComponent child : galleria.getChildren()) {
                if (!child.isRendered()) continue;
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)"ui-galleria-panel ui-helper-hidden", null);
                child.encodeAll(context);
                if (ComponentUtils.shouldRenderFacet(content)) {
                    writer.startElement("div", null);
                    writer.writeAttribute("class", (Object)"ui-galleria-panel-content", null);
                    content.encodeAll(context);
                    writer.endElement("div");
                }
                writer.endElement("li");
            }
        } else {
            Map requestMap = context.getExternalContext().getRequestMap();
            Collection value = (Collection)galleria.getValue();
            if (value != null) {
                Iterator it = value.iterator();
                while (it.hasNext()) {
                    requestMap.put(var, it.next());
                    writer.startElement("li", null);
                    writer.writeAttribute("class", (Object)"ui-galleria-panel ui-helper-hidden", null);
                    this.renderChildren(context, (UIComponent)galleria);
                    if (content != null) {
                        writer.startElement("div", null);
                        writer.writeAttribute("class", (Object)"ui-galleria-panel-content", null);
                        content.encodeAll(context);
                        writer.endElement("div");
                    }
                    writer.endElement("li");
                }
            }
            requestMap.remove(var);
        }
        writer.endElement("ul");
        writer.endElement("div");
    }

    public void encodeScript(FacesContext context, UIComponent component) throws IOException {
        Galleria galleria = (Galleria)component;
        WidgetBuilder wb = this.getWidgetBuilder(context);
        if (context.isPostback()) {
            wb.init("Galleria", galleria);
        } else {
            wb.initWithWindowLoad("Galleria", galleria);
        }
        wb.attr("showFilmstrip", galleria.isShowFilmstrip(), true).attr("frameWidth", galleria.getFrameWidth(), 60).attr("frameHeight", galleria.getFrameHeight(), 40).attr("autoPlay", galleria.isAutoPlay(), true).attr("transitionInterval", galleria.getTransitionInterval(), 4000).attr("effect", galleria.getEffect(), "fade").attr("effectSpeed", galleria.getEffectSpeed(), 500).attr("showCaption", galleria.isShowCaption(), false).attr("panelWidth", galleria.getPanelWidth(), Integer.MIN_VALUE).attr("panelHeight", galleria.getPanelHeight(), Integer.MIN_VALUE).attr("custom", galleria.getFacet("content") != null).attr("touchable", ComponentUtils.isTouchable(context, galleria), true);
        wb.finish();
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

