/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.graphicimage;

import java.io.IOException;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.graphicimage.GraphicImage;
import org.primefaces.component.graphicimage.GraphicImageBase;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.DynamicContentSrcBuilder;
import org.primefaces.util.HTML;
import org.primefaces.util.Lazy;

public class GraphicImageRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        GraphicImage image = (GraphicImage)component;
        String clientId = image.getClientId(context);
        String imageSrc = this.getImageSrc(context, image);
        writer.startElement("img", (UIComponent)image);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("src", (Object)imageSrc, null);
        if (image.getAlt() == null) {
            writer.writeAttribute("alt", (Object)"", null);
        }
        if (image.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)image.getStyleClass(), "styleClass");
        }
        this.renderPassThruAttributes(context, (UIComponent)image, HTML.IMG_ATTRS);
        writer.endElement("img");
    }

    protected String getImageSrc(FacesContext context, GraphicImage image) {
        String name = image.getName();
        if (name != null) {
            String libName = image.getLibrary();
            ResourceHandler handler = context.getApplication().getResourceHandler();
            Resource res = handler.createResource(name, libName);
            if (res == null) {
                return "RES_NOT_FOUND";
            }
            String requestPath = res.getRequestPath();
            return context.getExternalContext().encodeResourceURL(requestPath);
        }
        return DynamicContentSrcBuilder.build(context, (UIComponent)image, image.getValueExpression(GraphicImageBase.PropertyKeys.value.name()), new Lazy<Object>(() -> image.getValue()), image.isCache(), image.isStream());
    }
}

