/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.timeline;

import java.io.IOException;
import java.io.Writer;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.timeline.Timeline;
import org.primefaces.model.timeline.TimelineEvent;
import org.primefaces.model.timeline.TimelineGroup;
import org.primefaces.model.timeline.TimelineModel;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.CalendarUtils;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.EscapeUtils;
import org.primefaces.util.FastStringWriter;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class TimelineRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Timeline timeline = (Timeline)component;
        this.encodeMarkup(context, timeline);
        this.encodeScript(context, timeline);
    }

    protected void encodeMarkup(FacesContext context, Timeline timeline) throws IOException {
        UIComponent menuFacet;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = timeline.getClientId(context);
        writer.startElement("div", (UIComponent)timeline);
        writer.writeAttribute("id", (Object)clientId, "id");
        if (timeline.getStyle() != null) {
            writer.writeAttribute("style", (Object)timeline.getStyle(), "style");
        }
        if (timeline.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)timeline.getStyleClass(), "styleClass");
        }
        if (ComponentUtils.shouldRenderFacet(menuFacet = timeline.getFacet("menu"))) {
            writer.startElement("div", null);
            StringBuilder cssMenu = new StringBuilder("timeline-menu");
            if ("top".equals(timeline.getOrientationAxis())) {
                cssMenu.append(" timeline-menu-axis-top");
            } else if ("both".equals(timeline.getOrientationAxis())) {
                cssMenu.append(" timeline-menu-axis-both");
            }
            if (ComponentUtils.isRTL(context, timeline)) {
                cssMenu.append(" timeline-menu-rtl");
            }
            writer.writeAttribute("class", (Object)cssMenu.toString(), null);
            writer.writeAttribute("style", (Object)"display:none;", null);
            menuFacet.encodeAll(context);
            writer.endElement("div");
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, Timeline timeline) throws IOException {
        UIComponent loadingFacet;
        UIComponent menuFacet;
        TimelineModel<Object, Object> model = timeline.getValue();
        if (model == null) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        ZoneId zoneId = CalendarUtils.calculateZoneId(timeline.getTimeZone());
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(zoneId);
        FastStringWriter fsw = new FastStringWriter();
        FastStringWriter fswHtml = new FastStringWriter();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Timeline", timeline);
        List<TimelineEvent<Object>> events = model.getEvents();
        List<TimelineGroup<Object>> groups = this.calculateGroupsFromModel(model);
        HashMap<String, String> groupsContent = null;
        if (!groups.isEmpty()) {
            groupsContent = new HashMap<String, String>();
        }
        UIComponent groupFacet = timeline.getFacet("group");
        int groupsSize = groups.size();
        if (groupFacet != null || groupsSize > 0) {
            if (groupsSize > 0) {
                writer.write(",groups:[");
                for (int i = 0; i < groupsSize; ++i) {
                    Integer order = model.getGroups() != null ? Integer.valueOf(i) : null;
                    writer.write(this.encodeGroup(context, fsw, fswHtml, timeline, groupFacet, groupsContent, groups.get(i), order));
                    if (i + 1 >= groupsSize) continue;
                    writer.write(",");
                }
                writer.write("]");
            } else {
                writer.write(",groups:[]");
            }
        }
        writer.write(",data:[");
        UIComponent eventTitleFacet = timeline.getFacet("eventTitle");
        int size = events != null ? events.size() : 0;
        for (int i = 0; i < size; ++i) {
            writer.write(this.encodeEvent(context, fsw, fswHtml, timeline, eventTitleFacet, zoneId, groups, events.get(i)));
            if (i + 1 >= size) continue;
            writer.write(",");
        }
        writer.write("]");
        if (timeline.isShowCurrentTime()) {
            wb.nativeAttr("currentTime", this.encodeDate(dateTimeFormatter, LocalDateTime.now(CalendarUtils.calculateZoneId(timeline.getClientTimeZone()))));
        }
        if (timeline.getPreloadFactor().floatValue() < 0.0f) {
            wb.attr("preloadFactor", 0);
        } else {
            wb.attr("preloadFactor", timeline.getPreloadFactor());
        }
        if (timeline.getDropHoverStyleClass() != null) {
            wb.attr("hoverClass", timeline.getDropHoverStyleClass());
        }
        if (timeline.getDropActiveStyleClass() != null) {
            wb.attr("activeClass", timeline.getDropActiveStyleClass());
        }
        if (timeline.getDropAccept() != null) {
            wb.attr("accept", timeline.getDropAccept());
        }
        if (timeline.getDropScope() != null) {
            wb.attr("scope", timeline.getDropScope());
        }
        if (timeline.getExtender() != null) {
            wb.nativeAttr("extender", timeline.getExtender());
        }
        if (ComponentUtils.shouldRenderFacet(menuFacet = timeline.getFacet("menu"))) {
            wb.attr("isMenuPresent", Boolean.TRUE);
        }
        writer.write(",opts:{");
        writer.write("autoResize: " + timeline.isResponsive());
        if (timeline.getClientTimeZone() != null) {
            ZoneOffset zoneOffset = CalendarUtils.calculateZoneOffset(timeline.getClientTimeZone());
            if (ZoneOffset.UTC.equals(zoneOffset)) {
                wb.callback("moment", "function(date)", "return vis.moment(date).utc();");
            } else {
                wb.callback("moment", "function(date)", "return vis.moment(date).utcOffset('" + EscapeUtils.forJavaScript(zoneOffset.toString()) + "');");
            }
        }
        if (timeline.getHeight() != null) {
            wb.attr("height", timeline.getHeight());
        }
        if (timeline.getMinHeight() != null) {
            wb.attr("minHeight", timeline.getMinHeight());
        }
        if (timeline.getMaxHeight() != null) {
            wb.attr("maxHeight", timeline.getMaxHeight());
        }
        wb.attr("horizontalScroll", timeline.isHorizontalScroll(), false);
        wb.attr("verticalScroll", timeline.isVerticalScroll(), false);
        wb.attr("width", timeline.getWidth());
        wb.nativeAttr("orientation", "{axis:'" + timeline.getOrientationAxis() + "',item:'" + timeline.getOrientationItem() + "'}");
        wb.nativeAttr("editable", "{add:" + timeline.isEditableAdd() + ",remove:" + timeline.isEditableRemove() + ",updateTime:" + timeline.isEditableTime() + ",updateGroup:" + timeline.isEditableGroup() + ",overrideItems:" + timeline.isEditableOverrideItems() + "}");
        wb.attr("selectable", timeline.isSelectable());
        if (timeline.getStart() != null) {
            wb.nativeAttr("start", this.encodeDate(dateTimeFormatter, timeline.getStart()));
        }
        if (timeline.getEnd() != null) {
            wb.nativeAttr("end", this.encodeDate(dateTimeFormatter, timeline.getEnd()));
        }
        if (timeline.getMin() != null) {
            wb.nativeAttr("min", this.encodeDate(dateTimeFormatter, timeline.getMin()));
        }
        if (timeline.getMax() != null) {
            wb.nativeAttr("max", this.encodeDate(dateTimeFormatter, timeline.getMax()));
        }
        boolean zoomable = timeline.isZoomable();
        boolean moveable = timeline.isMoveable();
        wb.attr("zoomable", zoomable);
        wb.attr("moveable", moveable);
        if (zoomable) {
            wb.attr("zoomMin", timeline.getZoomMin());
            wb.attr("zoomMax", timeline.getZoomMax());
            if (moveable && LangUtils.isNotBlank(timeline.getZoomKey())) {
                wb.attr("zoomKey", timeline.getZoomKey());
            }
        }
        wb.nativeAttr("margin", "{axis:" + timeline.getEventMarginAxis() + ",item:{horizontal:" + timeline.getEventHorizontalMargin() + ",vertical:" + timeline.getEventVerticalMargin() + "}}");
        if (timeline.getEventStyle() != null) {
            wb.attr("type", timeline.getEventStyle());
        }
        if (timeline.isGroupsOrder()) {
            List<TimelineGroup<Object>> modelGroups = model.getGroups();
            if (modelGroups != null && !modelGroups.isEmpty()) {
                wb.attr("groupOrder", "order");
            } else {
                wb.attr("groupOrder", "content");
            }
        }
        if (timeline.getSnap() != null) {
            wb.nativeAttr("snap", timeline.getSnap());
        }
        wb.attr("stack", timeline.isStackEvents());
        wb.attr("showCurrentTime", timeline.isShowCurrentTime());
        wb.attr("showMajorLabels", timeline.isShowMajorLabels());
        wb.attr("showMinorLabels", timeline.isShowMinorLabels());
        wb.attr("locale", timeline.calculateLocale(context).toString());
        wb.attr("clickToUse", timeline.isClickToUse());
        wb.attr("showTooltips", timeline.isShowTooltips());
        wb.nativeAttr("tooltip", "{followMouse:" + timeline.isTooltipFollowMouse() + ",overflowMethod:'" + timeline.getTooltipOverflowMethod() + "',delay:" + timeline.getTooltipDelay() + "}");
        if (ComponentUtils.isRTL(context, timeline)) {
            wb.attr("rtl", Boolean.TRUE);
        }
        if (ComponentUtils.shouldRenderFacet(loadingFacet = timeline.getFacet("loading"))) {
            String loading = this.encodeAllToString(context, writer, fswHtml, loadingFacet);
            wb.nativeAttr("loadingScreenTemplate", "function() { return \"" + EscapeUtils.forJavaScript(loading) + "\";}");
        }
        writer.write("}");
        this.encodeClientBehaviors(context, timeline);
        wb.finish();
    }

    protected String encodeGroup(FacesContext context, FastStringWriter fsw, FastStringWriter fswHtml, Timeline timeline, UIComponent groupFacet, Map<String, String> groupsContent, TimelineGroup<?> group, Integer order) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        fsw.write("{id: \"" + EscapeUtils.forJavaScriptBlock(group.getId()) + "\"");
        Object data = group.getData();
        if (!LangUtils.isValueBlank(timeline.getVarGroup()) && data != null) {
            context.getExternalContext().getRequestMap().put(timeline.getVarGroup(), data);
        }
        if (ComponentUtils.shouldRenderFacet(groupFacet)) {
            String groupRender = this.encodeAllToString(context, writer, fswHtml, groupFacet);
            groupsContent.put(group.getId(), EscapeUtils.forJavaScript(groupRender));
            fsw.write(", content:\"" + groupsContent.get(group.getId()) + "\"");
        } else if (data != null) {
            groupsContent.put(group.getId(), EscapeUtils.forJavaScript(data.toString()));
            fsw.write(", content:\"" + groupsContent.get(group.getId()) + "\"");
        }
        if (group.getTreeLevel() != null) {
            fsw.write(", treeLevel:\"" + group.getTreeLevel() + "\"");
            List<String> nestedGroups = group.getNestedGroups();
            if (nestedGroups != null && !nestedGroups.isEmpty()) {
                fsw.write(", nestedGroups: [");
                Iterator<String> iter = nestedGroups.iterator();
                while (iter.hasNext()) {
                    fsw.write("\"" + EscapeUtils.forJavaScriptBlock(iter.next()) + "\"");
                    if (!iter.hasNext()) continue;
                    fsw.write(",");
                }
                fsw.write("]");
            }
        }
        if (timeline.getGroupStyle() != null) {
            fsw.write(", style: \"" + timeline.getGroupStyle() + "\"");
        }
        if (group.getStyleClass() != null) {
            fsw.write(", className: \"" + group.getStyleClass() + "\"");
        }
        if (group.getTitle() != null) {
            fsw.write(", title: \"" + EscapeUtils.forJavaScript(group.getTitle()) + "\"");
        }
        if (order != null) {
            fsw.write(", order: " + order);
        }
        if (!LangUtils.isValueBlank(group.getSubgroupOrder())) {
            fsw.write(", subgroupOrder: \"" + EscapeUtils.forJavaScript(group.getSubgroupOrder()) + "\"");
        }
        if (!LangUtils.isValueBlank(group.getSubgroupStack())) {
            fsw.write(", subgroupStack: " + EscapeUtils.forJavaScript(group.getSubgroupStack()));
        }
        if (!LangUtils.isValueBlank(group.getSubgroupVisibility())) {
            fsw.write(", subgroupVisibility: " + EscapeUtils.forJavaScript(group.getSubgroupVisibility()));
        }
        fsw.write("}");
        String groupJson = fsw.toString();
        fsw.reset();
        return groupJson;
    }

    protected String encodeEvent(FacesContext context, FastStringWriter fsw, FastStringWriter fswHtml, Timeline timeline, UIComponent eventTitleFacet, ZoneId zoneId, List<TimelineGroup<Object>> groups, TimelineEvent<?> event) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(zoneId);
        fsw.write("{id: \"" + EscapeUtils.forJavaScript(event.getId()) + "\"");
        if (event.getStartDate() != null) {
            fsw.write(", start: " + this.encodeDate(dateTimeFormatter, event.getStartDate()));
        } else {
            fsw.write(", start: null");
        }
        if (event.getEndDate() != null) {
            fsw.write(", end: " + this.encodeDate(dateTimeFormatter, event.getEndDate()));
        } else {
            fsw.write(", end: null");
        }
        if (event.isEditableTime() != null || event.isEditableGroup() != null || event.isEditableRemove() != null) {
            fsw.write(", editable: {");
            boolean isSet = false;
            if (event.isEditableTime() != null) {
                fsw.write("updateTime: " + event.isEditableTime());
                isSet = true;
            }
            if (event.isEditableGroup() != null) {
                if (isSet) {
                    fsw.write(",");
                }
                fsw.write("updateGroup: " + event.isEditableGroup());
                isSet = true;
            }
            if (event.isEditableRemove() != null) {
                if (isSet) {
                    fsw.write(",");
                }
                fsw.write("remove: " + event.isEditableRemove());
                isSet = true;
            }
            fsw.write("}");
        }
        TimelineGroup<Object> foundGroup = null;
        if (event.getGroup() != null) {
            for (TimelineGroup<Object> group : groups) {
                if (!Objects.equals(group.getId(), event.getGroup())) continue;
                foundGroup = group;
                break;
            }
        }
        if (foundGroup != null) {
            fsw.write(", group: \"" + EscapeUtils.forJavaScript(foundGroup.getId()) + "\"");
            if (!LangUtils.isValueBlank(event.getSubgroup())) {
                fsw.write(", subgroup: \"" + EscapeUtils.forJavaScript(event.getSubgroup()) + "\"");
            }
        } else {
            fsw.write(", group: null");
        }
        if (!LangUtils.isValueBlank(event.getStyleClass())) {
            fsw.write(", className: \"" + event.getStyleClass() + "\"");
        } else {
            fsw.write(", className: null");
        }
        Object data = event.getData();
        if (!LangUtils.isValueBlank(timeline.getVar()) && data != null) {
            context.getExternalContext().getRequestMap().put(timeline.getVar(), data);
        }
        if (event.getTitle() != null) {
            fsw.write(", title:\"");
            fsw.write(EscapeUtils.forJavaScript(event.getTitle()));
            fsw.write("\"");
        } else if (ComponentUtils.shouldRenderFacet(eventTitleFacet)) {
            String title = this.encodeAllToString(context, writer, fswHtml, eventTitleFacet);
            fsw.write(", title:\"");
            fsw.write(EscapeUtils.forJavaScript(title));
            fsw.write("\"");
        }
        fsw.write(", content:\"");
        if (timeline.getChildCount() > 0) {
            ResponseWriter clonedWriter = writer.cloneWithWriter((Writer)fswHtml);
            context.setResponseWriter(clonedWriter);
            this.renderChildren(context, (UIComponent)timeline);
            context.setResponseWriter(writer);
            fsw.write(EscapeUtils.forJavaScript(fswHtml.toString()));
            fswHtml.reset();
        } else if (data != null) {
            fsw.write(data.toString());
        }
        fsw.write("\"");
        fsw.write("}");
        String eventJson = fsw.toString();
        fsw.reset();
        return eventJson;
    }

    private String encodeDate(DateTimeFormatter dateTimeFormatter, LocalDateTime date) {
        ZonedDateTime zdt = date.atZone(dateTimeFormatter.getZone());
        String formatted = dateTimeFormatter.format(zdt);
        String encoded = formatted.startsWith("-") ? "new Date(" + zdt.getYear() + ", " + (zdt.getMonthValue() - 1) + ", " + zdt.getDayOfMonth() + ", " + zdt.getHour() + ", " + zdt.getMinute() + ", " + zdt.getSecond() + ", 0)" : "new Date('" + formatted + "')";
        return encoded;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    private String encodeAllToString(FacesContext context, ResponseWriter writer, FastStringWriter fswHtml, UIComponent component) throws IOException {
        ResponseWriter clonedWriter = writer.cloneWithWriter((Writer)fswHtml);
        context.setResponseWriter(clonedWriter);
        component.encodeAll(context);
        context.setResponseWriter(writer);
        String encoded = fswHtml.toString();
        fswHtml.reset();
        return encoded;
    }

    List<TimelineGroup<Object>> calculateGroupsFromModel(TimelineModel<Object, Object> model) {
        List<TimelineGroup<Object>> groups = model.getGroups();
        if (groups != null) {
            return groups;
        }
        return model.getEvents().stream().map(TimelineEvent::getGroup).filter(Objects::nonNull).distinct().map(group -> new TimelineGroup<String>((String)group, (String)group)).collect(Collectors.toList());
    }
}

