/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.virusscan.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.primefaces.model.file.UploadedFile;
import org.primefaces.util.MessageFactory;
import org.primefaces.virusscan.VirusException;
import org.primefaces.virusscan.VirusScanner;
import org.primefaces.virusscan.impl.ClamDaemonClient;

public class ClamDaemonScanner
implements VirusScanner {
    private static final Logger LOGGER = Logger.getLogger(ClamDaemonScanner.class.getName());
    private static final String CONTEXT_PARAM_HOST = "primefaces.virusscan.CLAMAV_HOST";
    private static final String CONTEXT_PARAM_PORT = "primefaces.virusscan.CLAMAV_PORT";
    private static final String CONTEXT_PARAM_TIMEOUT = "primefaces.virusscan.CLAMAV_TIMEOUT";
    private static final String CONTEXT_PARAM_BUFFER = "primefaces.virusscan.CLAMAV_BUFFER";
    private ClamDaemonClient client;

    @Override
    public boolean isEnabled() {
        ExternalContext ctx = FacesContext.getCurrentInstance().getExternalContext();
        return ctx.getInitParameter(CONTEXT_PARAM_HOST) != null && ctx.getInitParameter(CONTEXT_PARAM_PORT) != null;
    }

    @Override
    public void scan(UploadedFile file) {
        try {
            ClamDaemonClient client = this.getClamAvClient();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(file.getContent());
            byte[] reply = client.scan(inputStream);
            String message = new String(reply, StandardCharsets.US_ASCII).trim();
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Scanner replied with message:" + message);
            }
            if (!ClamDaemonClient.isCleanReply(reply)) {
                String error = this.createErrorMessage(file, message);
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "ClamAV Error:" + error);
                }
                throw new VirusException(error);
            }
        }
        catch (VirusException ex) {
            throw ex;
        }
        catch (IOException | RuntimeException ex) {
            String error = String.format("Unexpected error scanning file - %s", ex.getMessage());
            throw new VirusException(error);
        }
    }

    protected String createErrorMessage(UploadedFile file, String response) {
        return MessageFactory.getMessage("primefaces.fileupload.CLAM_AV_FILE", file.getFileName(), response);
    }

    ClamDaemonClient getClamAvClient() {
        if (this.client != null) {
            return this.client;
        }
        ExternalContext ctx = FacesContext.getCurrentInstance().getExternalContext();
        String host = ctx.getInitParameter(CONTEXT_PARAM_HOST);
        int port = Integer.parseInt(ctx.getInitParameter(CONTEXT_PARAM_PORT));
        int timeout = 60000;
        if (ctx.getInitParameter(CONTEXT_PARAM_TIMEOUT) != null) {
            timeout = Integer.parseInt(ctx.getInitParameter(CONTEXT_PARAM_TIMEOUT));
        }
        int chunkSize = 2048;
        if (ctx.getInitParameter(CONTEXT_PARAM_BUFFER) != null) {
            chunkSize = Integer.parseInt(ctx.getInitParameter(CONTEXT_PARAM_BUFFER));
        }
        this.client = new ClamDaemonClient(host, port, timeout, chunkSize);
        return this.client;
    }
}

