/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.application.resource;

import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.io.IOException;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import net.glxn.qrgen.QRCode;
import net.glxn.qrgen.image.ImageType;
import org.primefaces.application.resource.BaseDynamicContentHandler;
import org.primefaces.util.LangUtils;

public class QRCodeHandler
extends BaseDynamicContentHandler {
    @Override
    public void handle(FacesContext context) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        ExternalContext externalContext = context.getExternalContext();
        String sessionKey = (String)params.get("pfdrid");
        Map session = externalContext.getSessionMap();
        Map barcodeMapping = (Map)session.get("primefaces.barcodeMapping");
        String value = (String)barcodeMapping.get(sessionKey);
        if (value != null) {
            boolean cache = Boolean.parseBoolean((String)params.get("pfdrid_c"));
            externalContext.setResponseStatus(200);
            externalContext.setResponseContentType("image/png");
            this.handleCache(externalContext, cache);
            ErrorCorrectionLevel ecl = ErrorCorrectionLevel.L;
            String errorCorrection = (String)params.get("qrec");
            if (!LangUtils.isValueBlank(errorCorrection)) {
                ecl = ErrorCorrectionLevel.valueOf((String)errorCorrection);
            }
            QRCode.from((String)value).to(ImageType.PNG).withErrorCorrection(ecl).withCharset("UTF-8").writeTo(externalContext.getResponseOutputStream());
            externalContext.responseFlushBuffer();
            context.responseComplete();
        }
    }
}

