/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.cache;

import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.primefaces.cache.CacheProvider;

public class EHCacheProvider
implements CacheProvider {
    private final CacheManager cacheManager = CacheManager.create();

    @Override
    public Object get(String region, String key) {
        Cache cacheRegion = this.getRegion(region);
        Element element = cacheRegion.get((Serializable)((Object)key));
        if (element != null) {
            return element.getObjectValue();
        }
        return null;
    }

    @Override
    public void put(String region, String key, Object object) {
        Cache cacheRegion = this.getRegion(region);
        cacheRegion.put(new Element((Object)key, object));
    }

    @Override
    public void remove(String region, String key) {
        Cache cacheRegion = this.getRegion(region);
        cacheRegion.remove((Serializable)((Object)key));
    }

    @Override
    public void clear() {
        String[] cacheNames = this.getCacheManager().getCacheNames();
        if (cacheNames != null) {
            for (String cacheName : cacheNames) {
                Cache cache = this.getRegion(cacheName);
                cache.removeAll();
            }
        }
    }

    protected Cache getRegion(String regionName) {
        Cache region = this.getCacheManager().getCache(regionName);
        if (region == null) {
            this.getCacheManager().addCache(regionName);
            region = this.getCacheManager().getCache(regionName);
        }
        return region;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }
}

