/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.clientwindow;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.primefaces.util.ResourceUtils;

public class PrimeClientWindowUtils {
    public static final String INITIAL_REDIRECT_COOKIE_PREFIX = "pf.initialredirect-";
    public static final int WINDOW_ID_LENGTH = 5;

    private PrimeClientWindowUtils() {
    }

    public static void addInitialRedirectCookie(FacesContext context, String windowId) {
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        properties.put("path", "/");
        properties.put("maxAge", 30);
        ResourceUtils.addResponseCookie(context, PrimeClientWindowUtils.getCookieName(windowId), "true", properties);
    }

    public static Object getInitialRedirectCookie(FacesContext context, String windowId) {
        String cookie;
        Map cookieMap = context.getExternalContext().getRequestCookieMap();
        if (cookieMap.containsKey(cookie = PrimeClientWindowUtils.getCookieName(windowId))) {
            return cookieMap.get(cookie);
        }
        return null;
    }

    public static String getCookieName(String windowId) {
        return INITIAL_REDIRECT_COOKIE_PREFIX + windowId;
    }

    public static String secureWindowId(String windowId) {
        if (windowId != null && windowId.length() > 5) {
            windowId = windowId.substring(0, 5);
        }
        return windowId;
    }

    public static String generateNewWindowId() {
        return UUID.randomUUID().toString().substring(0, 5);
    }

    public static boolean isPost(FacesContext facesContext) {
        if (facesContext.isPostback()) {
            return true;
        }
        Object request = facesContext.getExternalContext().getRequest();
        return request instanceof HttpServletRequest && "POST".equals(((HttpServletRequest)request).getMethod());
    }
}

