/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.carousel;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.carousel.Carousel;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class CarouselRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Map params = context.getExternalContext().getRequestParameterMap();
        Carousel carousel = (Carousel)component;
        String clientId = carousel.getClientId(context);
        String pageParam = clientId + "_page";
        String collapsedParam = clientId + "_collapsed";
        if (params.containsKey(pageParam)) {
            carousel.setFirstVisible(Integer.parseInt((String)params.get(pageParam)) * carousel.getNumVisible());
        }
        if (params.containsKey(collapsedParam)) {
            carousel.setCollapsed(Boolean.parseBoolean((String)params.get(collapsedParam)));
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Carousel carousel = (Carousel)component;
        this.encodeMarkup(context, carousel);
        this.encodeScript(context, carousel);
    }

    private void encodeScript(FacesContext context, Carousel carousel) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Carousel", carousel);
        wb.attr("firstVisible", carousel.getFirstVisible(), 0).attr("circular", carousel.isCircular(), false).attr("vertical", carousel.isVertical(), false).attr("numVisible", carousel.getNumVisible(), 3).attr("autoplayInterval", carousel.getAutoPlayInterval(), 0).attr("pageLinks", carousel.getPageLinks(), 3).attr("effect", carousel.getEffect(), null).attr("effectDuration", carousel.getEffectDuration(), Integer.MIN_VALUE).attr("easing", carousel.getEasing(), null).attr("responsive", carousel.isResponsive(), false).attr("breakpoint", carousel.getBreakpoint(), 560).attr("stateful", carousel.isStateful(), false).attr("touchable", ComponentUtils.isTouchable(context, carousel), true);
        if (carousel.isToggleable()) {
            wb.attr("toggleable", true).attr("toggleSpeed", carousel.getToggleSpeed()).attr("collapsed", carousel.isCollapsed());
        }
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, Carousel carousel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = carousel.getClientId(context);
        boolean collapsed = carousel.isCollapsed();
        String style = carousel.getStyle();
        String styleClass = carousel.getStyleClass();
        styleClass = styleClass == null ? "ui-carousel ui-widget ui-widget-content ui-corner-all ui-hidden-container" : "ui-carousel ui-widget ui-widget-content ui-corner-all ui-hidden-container " + styleClass;
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeHeader(context, carousel);
        this.encodeContent(context, carousel);
        this.encodeFooter(context, carousel);
        int pageCount = this.calculatePageCount(carousel);
        this.encodeStateField(context, carousel, clientId + "_page", pageCount);
        if (carousel.isToggleable()) {
            this.encodeStateField(context, carousel, clientId + "_collapsed", String.valueOf(collapsed));
        }
        writer.endElement("div");
    }

    protected void encodeContent(FacesContext context, Carousel carousel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String itemStyleClass = carousel.getItemStyleClass();
        itemStyleClass = itemStyleClass == null ? "ui-carousel-item ui-widget-content ui-corner-all" : "ui-carousel-item ui-widget-content ui-corner-all " + itemStyleClass;
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)(carousel.isVertical() ? "ui-carousel-viewport ui-carousel-vertical-viewport" : "ui-carousel-viewport"), null);
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-carousel-items", null);
        if (carousel.isCollapsed()) {
            writer.writeAttribute("style", (Object)"display:none", null);
        }
        if (carousel.getVar() != null) {
            for (int i = 0; i < carousel.getRowCount(); ++i) {
                carousel.setIndex(i);
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)itemStyleClass, "itemStyleClass");
                if (carousel.getItemStyle() != null) {
                    writer.writeAttribute("style", (Object)carousel.getItemStyle(), "itemStyle");
                }
                this.renderChildren(context, (UIComponent)carousel);
                writer.endElement("li");
            }
            carousel.setIndex(-1);
        } else {
            for (UIComponent kid : carousel.getChildren()) {
                if (!kid.isRendered()) continue;
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)itemStyleClass, "itemStyleClass");
                if (carousel.getItemStyle() != null) {
                    writer.writeAttribute("style", (Object)carousel.getItemStyle(), "itemStyle");
                }
                this.renderChild(context, kid);
                writer.endElement("li");
            }
        }
        writer.endElement("ul");
        writer.endElement("div");
    }

    protected void encodeHeader(FacesContext context, Carousel carousel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean vertical = carousel.isVertical();
        String clientId = carousel.getClientId(context);
        String var = carousel.getVar();
        int rowCount = carousel.getRowCount();
        int renderedChildCount = carousel.getRenderedChildCount();
        int pageCount = this.calculatePageCount(carousel);
        int itemCount = var != null ? rowCount : renderedChildCount;
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-carousel-header ui-widget-header ui-corner-all", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-carousel-header-title", null);
        UIComponent facet = carousel.getFacet("header");
        String text = carousel.getHeaderText();
        if (ComponentUtils.shouldRenderFacet(facet)) {
            facet.encodeAll(context);
        } else if (text != null) {
            writer.writeText((Object)text, "headerText");
        }
        writer.endElement("div");
        if (carousel.isToggleable()) {
            String icon = carousel.isCollapsed() ? "ui-icon-plusthick" : "ui-icon-minusthick";
            this.encodeIcon(context, carousel, icon, clientId + "_toggler");
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)(vertical ? "ui-carousel-button ui-carousel-next-button ui-icon ui-icon-circle-triangle-s" : "ui-carousel-button ui-carousel-next-button ui-icon ui-icon-circle-triangle-e"), null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)(vertical ? "ui-carousel-button ui-carousel-prev-button ui-icon ui-icon-circle-triangle-n" : "ui-carousel-button ui-carousel-prev-button ui-icon ui-icon-circle-triangle-w"), null);
        writer.endElement("span");
        if (pageCount <= carousel.getPageLinks()) {
            this.encodePageLinks(context, carousel, pageCount);
        } else {
            this.encodeDropDown(context, carousel, clientId + "_dropdown", "ui-carousel-dropdown ui-widget ui-state-default ui-corner-left", pageCount);
        }
        if (carousel.isResponsive()) {
            this.encodeDropDown(context, carousel, clientId + "_responsivedropdown", "ui-carousel-dropdown-responsive ui-widget ui-state-default ui-corner-left", itemCount);
        }
        writer.endElement("div");
    }

    protected void encodePageLinks(FacesContext context, Carousel carousel, int pageCount) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-carousel-page-links", null);
        for (int i = 0; i < pageCount; ++i) {
            writer.startElement("a", null);
            writer.writeAttribute("href", (Object)"#", null);
            writer.writeAttribute("class", (Object)"ui-icon ui-carousel-page-link ui-icon-radio-off", null);
            writer.endElement("a");
        }
        writer.endElement("div");
    }

    protected void encodeDropDown(FacesContext context, Carousel carousel, String name, String styleClass, int pageCount) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String template = carousel.getDropdownTemplate();
        writer.startElement("select", null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        for (int i = 0; i < pageCount; ++i) {
            writer.startElement("option", null);
            writer.writeAttribute("value", (Object)(i + 1), null);
            writer.write(template.replaceAll("\\{page\\}", String.valueOf(i + 1)));
            writer.endElement("option");
        }
        writer.endElement("select");
    }

    protected void encodeFooter(FacesContext context, Carousel carousel) throws IOException {
        UIComponent facet = carousel.getFacet("footer");
        String text = carousel.getFooterText();
        boolean renderFacet = ComponentUtils.shouldRenderFacet(facet);
        if (!renderFacet && text == null) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-carousel-footer ui-widget-header ui-corner-all", null);
        if (carousel.isCollapsed()) {
            writer.writeAttribute("style", (Object)"display:none", null);
        }
        if (renderFacet) {
            facet.encodeAll(context);
        } else {
            writer.writeText((Object)text, "footerText");
        }
        writer.endElement("div");
    }

    protected void encodeStateField(FacesContext context, Carousel carousel, String id, Object value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        writer.writeAttribute("value", value, null);
        writer.endElement("input");
    }

    protected void encodeIcon(FacesContext context, Carousel carousel, String iconClass, String id) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", null);
        if (id != null) {
            writer.writeAttribute("id", (Object)id, null);
        }
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("class", (Object)"ui-carousel-titlebar-icon ui-corner-all ui-state-default", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)("ui-icon " + iconClass), null);
        writer.endElement("span");
        writer.endElement("a");
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    protected int calculatePageCount(Carousel carousel) {
        String var = carousel.getVar();
        int rowCount = carousel.getRowCount();
        int numVisible = carousel.getNumVisible();
        int renderedChildCount = carousel.getRenderedChildCount();
        return var != null ? (int)Math.ceil((double)rowCount / (1.0 * (double)numVisible)) : renderedChildCount;
    }
}

