/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datagrid;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.faces.model.DataModel;
import org.primefaces.PrimeFaces;
import org.primefaces.component.datagrid.DataGridBase;
import org.primefaces.component.datagrid.DataGridState;
import org.primefaces.event.data.PageEvent;
import org.primefaces.model.LazyDataModel;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class DataGrid
extends DataGridBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.DataGrid";
    public static final String DATAGRID_CLASS = "ui-datagrid ui-widget";
    public static final String HEADER_CLASS = "ui-datagrid-header ui-widget-header ui-corner-top";
    public static final String FOOTER_CLASS = "ui-datagrid-footer ui-widget-header ui-corner-bottom";
    public static final String TABLE_CONTENT_CLASS = "ui-datagrid-content ui-widget-content";
    public static final String EMPTY_CONTENT_CLASS = "ui-datagrid-content ui-datagrid-content-empty ui-widget-content";
    public static final String TABLE_CLASS = "ui-datagrid-data";
    public static final String TABLE_ROW_CLASS = "ui-datagrid-row";
    public static final String GRID_CONTENT_CLASS = "ui-datagrid-content ui-widget-content ui-grid ui-grid-responsive";
    public static final String FLEX_GRID_CONTENT_CLASS = "ui-datagrid-content ui-widget-content p-grid";
    public static final String FLEX_GRID_ROW_CLASS = "p-grid";
    public static final String GRID_ROW_CLASS = "ui-g";
    public static final String COLUMN_CLASS = "ui-datagrid-column";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("page", PageEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public void loadLazyData() {
        DataModel model = this.getDataModel();
        if (model instanceof LazyDataModel) {
            LazyDataModel lazyModel = (LazyDataModel)model;
            List data = lazyModel.load(this.getFirst(), this.getRows(), Collections.emptyMap(), Collections.emptyMap());
            lazyModel.setPageSize(this.getRows());
            lazyModel.setWrappedData(data);
            if (ComponentUtils.isRequestSource((UIComponent)this, this.getFacesContext()) && this.isPaginator()) {
                PrimeFaces.current().ajax().addCallbackParam("totalRecords", lazyModel.getRowCount());
            }
        }
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (ComponentUtils.isRequestSource((UIComponent)this, context) && event instanceof AjaxBehaviorEvent) {
            this.setRowIndex(-1);
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            if ("page".equals(eventName)) {
                AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
                String clientId = this.getClientId(context);
                int rows = this.getRowsToRender();
                int first = Integer.parseInt((String)params.get(clientId + "_first"));
                int page = rows > 0 ? first / rows : 0;
                PageEvent pageEvent = new PageEvent((UIComponent)this, behaviorEvent.getBehavior(), page);
                pageEvent.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)pageEvent);
            }
        } else {
            super.queueEvent(event);
        }
    }

    @Override
    protected boolean shouldSkipChildren(FacesContext context) {
        Map params = context.getExternalContext().getRequestParameterMap();
        String paramValue = (String)params.get("primefaces.skipchildren");
        if (paramValue != null && !Boolean.parseBoolean(paramValue)) {
            return false;
        }
        return params.containsKey(this.getClientId(context) + "_skipChildren");
    }

    @Override
    public void restoreMultiViewState() {
        DataGridState ls = this.getMultiViewState(false);
        if (ls != null && this.isPaginator()) {
            this.setFirst(ls.getFirst());
            int rows = ls.getRows() == 0 ? this.getRows() : ls.getRows();
            this.setRows(rows);
        }
    }

    @Override
    public DataGridState getMultiViewState(boolean create) {
        FacesContext fc = this.getFacesContext();
        String viewId = fc.getViewRoot().getViewId();
        return PrimeFaces.current().multiViewState().get(viewId, this.getClientId(fc), create, DataGridState::new);
    }

    @Override
    public void resetMultiViewState() {
        this.setFirst(0);
    }
}

