/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.terminal;

import java.io.IOException;
import java.util.Arrays;
import javax.el.MethodExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.terminal.Terminal;
import org.primefaces.model.terminal.TerminalAutoCompleteMatches;
import org.primefaces.model.terminal.TerminalAutoCompleteModel;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class TerminalRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Terminal terminal = (Terminal)component;
        if (terminal.isCommandRequest()) {
            this.handleCommand(context, terminal);
        } else if (terminal.isAutoCompleteRequest()) {
            this.autoCompleteCommand(context, terminal);
        } else {
            this.encodeMarkup(context, terminal);
            this.encodeScript(context, terminal);
        }
    }

    protected void encodeMarkup(FacesContext context, Terminal terminal) throws IOException {
        String clientId = terminal.getClientId(context);
        String style = terminal.getStyle();
        String styleClass = terminal.getStyleClass();
        styleClass = styleClass == null ? "ui-terminal ui-widget ui-widget-content ui-corner-all" : "ui-terminal ui-widget ui-widget-content ui-corner-all " + styleClass;
        String welcomeMessage = terminal.getWelcomeMessage();
        String prompt = terminal.getPrompt();
        String inputId = clientId + "_input";
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)terminal);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (welcomeMessage != null) {
            writer.startElement("div", null);
            if (terminal.isEscape()) {
                writer.writeText((Object)welcomeMessage, null);
            } else {
                writer.write(welcomeMessage);
            }
            writer.endElement("div");
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-terminal-content", null);
        writer.endElement("div");
        writer.startElement("div", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-terminal-prompt", null);
        if (terminal.isEscape()) {
            writer.writeText((Object)prompt, null);
        } else {
            writer.write(prompt);
        }
        writer.endElement("span");
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        writer.writeAttribute("class", (Object)"ui-terminal-input", null);
        writer.endElement("input");
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, Terminal terminal) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Terminal", terminal);
        this.encodeClientBehaviors(context, terminal);
        wb.finish();
    }

    protected void handleCommand(FacesContext context, Terminal terminal) throws IOException {
        String[] tokens = this.getValueTokens(context, terminal);
        String command = tokens[0];
        String[] args = Arrays.copyOfRange(tokens, 1, tokens.length);
        MethodExpression commandHandler = terminal.getCommandHandler();
        String result = (String)commandHandler.invoke(context.getELContext(), new Object[]{command, args});
        ResponseWriter writer = context.getResponseWriter();
        writer.writeText((Object)result, null);
    }

    protected void autoCompleteCommand(FacesContext context, Terminal terminal) throws IOException {
        String[] tokens = this.getValueTokens(context, terminal);
        String command = tokens[0];
        String[] args = Arrays.copyOfRange(tokens, 1, tokens.length);
        TerminalAutoCompleteModel autoCompleteModel = terminal.getAutoCompleteModel();
        ResponseWriter writer = context.getResponseWriter();
        if (autoCompleteModel == null) {
            writer.write("null");
        } else {
            TerminalAutoCompleteMatches matches = terminal.traverseAutoCompleteModel(autoCompleteModel, command, args);
            writer.writeText((Object)matches.toString(), null);
        }
    }

    private String[] getValueTokens(FacesContext context, Terminal terminal) {
        String clientId = terminal.getClientId(context);
        String value = (String)context.getExternalContext().getRequestParameterMap().get(clientId + "_input");
        String[] tokens = value.trim().split(" ");
        return tokens;
    }
}

