/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.timeline;

import java.time.ZoneId;
import java.util.Collection;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.timeline.TimelineBase;
import org.primefaces.event.timeline.TimelineAddEvent;
import org.primefaces.event.timeline.TimelineDragDropEvent;
import org.primefaces.event.timeline.TimelineLazyLoadEvent;
import org.primefaces.event.timeline.TimelineModificationEvent;
import org.primefaces.event.timeline.TimelineRangeEvent;
import org.primefaces.event.timeline.TimelineSelectEvent;
import org.primefaces.model.timeline.TimelineEvent;
import org.primefaces.util.CalendarUtils;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.MapBuilder;
import org.primefaces.visit.UIDataContextCallback;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js"), @ResourceDependency(library="primefaces", name="timeline/timeline.css"), @ResourceDependency(library="primefaces", name="timeline/timeline.js")})
public class Timeline
extends TimelineBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Timeline";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("add", TimelineAddEvent.class).put("change", TimelineModificationEvent.class).put("changed", TimelineModificationEvent.class).put("edit", TimelineModificationEvent.class).put("delete", TimelineModificationEvent.class).put("select", TimelineSelectEvent.class).put("rangechange", TimelineRangeEvent.class).put("rangechanged", TimelineRangeEvent.class).put("lazyload", TimelineLazyLoadEvent.class).put("drop", TimelineDragDropEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (ComponentUtils.isRequestSource((UIComponent)this, context)) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            ZoneId zoneId = CalendarUtils.calculateZoneId(this.getTimeZone());
            if ("add".equals(eventName)) {
                TimelineAddEvent te = new TimelineAddEvent((UIComponent)this, behaviorEvent.getBehavior(), (String)params.get(clientId + "_id"), CalendarUtils.toLocalDateTime(zoneId, (String)params.get(clientId + "_startDate")), CalendarUtils.toLocalDateTime(zoneId, (String)params.get(clientId + "_endDate")), (String)params.get(clientId + "_group"));
                te.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)te);
                return;
            }
            if ("change".equals(eventName) || "changed".equals(eventName)) {
                TimelineEvent<Object> clonedEvent = null;
                TimelineEvent<Object> timelineEvent = this.getValue().getEvent((String)params.get(clientId + "_eventId"));
                if (timelineEvent != null) {
                    clonedEvent = TimelineEvent.builder(timelineEvent).startDate(CalendarUtils.toLocalDateTime(zoneId, (String)params.get(clientId + "_startDate"))).endDate(CalendarUtils.toLocalDateTime(zoneId, (String)params.get(clientId + "_endDate"))).group((String)params.get(clientId + "_group")).build();
                }
                TimelineModificationEvent te = new TimelineModificationEvent((UIComponent)this, behaviorEvent.getBehavior(), clonedEvent);
                te.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent(te);
                return;
            }
            if ("edit".equals(eventName) || "delete".equals(eventName)) {
                TimelineEvent<Object> clonedEvent = null;
                TimelineEvent<Object> timelineEvent = this.getValue().getEvent((String)params.get(clientId + "_eventId"));
                if (timelineEvent != null) {
                    clonedEvent = TimelineEvent.builder(timelineEvent).build();
                }
                TimelineModificationEvent<Object> te = new TimelineModificationEvent<Object>((UIComponent)this, behaviorEvent.getBehavior(), clonedEvent);
                te.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent(te);
                return;
            }
            if ("select".equals(eventName)) {
                TimelineEvent<Object> timelineEvent = this.getValue().getEvent((String)params.get(clientId + "_eventId"));
                TimelineSelectEvent<Object> te = new TimelineSelectEvent<Object>((UIComponent)this, behaviorEvent.getBehavior(), timelineEvent);
                te.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent(te);
                return;
            }
            if ("rangechange".equals(eventName) || "rangechanged".equals(eventName)) {
                TimelineRangeEvent te = new TimelineRangeEvent((UIComponent)this, behaviorEvent.getBehavior(), CalendarUtils.toLocalDateTime(zoneId, (String)params.get(clientId + "_startDate")), CalendarUtils.toLocalDateTime(zoneId, (String)params.get(clientId + "_endDate")));
                te.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)te);
                return;
            }
            if ("lazyload".equals(eventName)) {
                TimelineLazyLoadEvent te = new TimelineLazyLoadEvent((UIComponent)this, behaviorEvent.getBehavior(), CalendarUtils.toLocalDateTime(zoneId, (String)params.get(clientId + "_startDateFirst")), CalendarUtils.toLocalDateTime(zoneId, (String)params.get(clientId + "_endDateFirst")), CalendarUtils.toLocalDateTime(zoneId, (String)params.get(clientId + "_startDateSecond")), CalendarUtils.toLocalDateTime(zoneId, (String)params.get(clientId + "_endDateSecond")));
                te.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)te);
                return;
            }
            if ("drop".equals(eventName)) {
                Object data = null;
                String dragId = (String)params.get(clientId + "_dragId");
                String uiDataId = (String)params.get(clientId + "_uiDataId");
                if (dragId != null && uiDataId != null) {
                    UIDataContextCallback contextCallback = new UIDataContextCallback(dragId);
                    context.getViewRoot().invokeOnComponent(context, uiDataId, (ContextCallback)contextCallback);
                    data = contextCallback.getData();
                }
                TimelineDragDropEvent<Object> te = new TimelineDragDropEvent<Object>((UIComponent)this, behaviorEvent.getBehavior(), CalendarUtils.toLocalDateTime(zoneId, (String)params.get(clientId + "_startDate")), CalendarUtils.toLocalDateTime(zoneId, (String)params.get(clientId + "_endDate")), (String)params.get(clientId + "_group"), dragId, data);
                te.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent(te);
                return;
            }
        }
        super.queueEvent(event);
    }
}

