/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.config;

import java.io.InputStream;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.validation.Validation;
import org.primefaces.util.LangUtils;

public class PrimeEnvironment {
    private static final Logger LOGGER = Logger.getLogger(PrimeEnvironment.class.getName());
    private final boolean beanValidationAvailable;
    private final boolean atLeastEl22 = LangUtils.tryToLoadClassForName("javax.el.ValueReference") != null;
    private final boolean atLeastJsf23 = LangUtils.tryToLoadClassForName("javax.faces.component.UIImportConstants") != null;
    private final boolean atLeastJsf22 = LangUtils.tryToLoadClassForName("javax.faces.flow.Flow") != null;
    private final boolean atLeastJsf21 = LangUtils.tryToLoadClassForName("javax.faces.component.TransientStateHolder") != null;
    private final boolean mojarra;
    private final boolean atLeastBv11 = LangUtils.tryToLoadClassForName("javax.validation.executable.ExecutableValidator") != null;
    private final boolean atLeastServlet30 = LangUtils.tryToLoadClassForName("javax.servlet.SessionCookieConfig") != null;
    private final String buildVersion;
    private final boolean htmlSanitizerAvailable;

    public PrimeEnvironment(FacesContext context) {
        this.beanValidationAvailable = this.resolveBeanValidationAvailable();
        this.buildVersion = this.resolveBuildVersion();
        this.htmlSanitizerAvailable = LangUtils.tryToLoadClassForName("org.owasp.html.PolicyFactory") != null;
        this.mojarra = context == null || context.getExternalContext() == null ? false : context.getExternalContext().getApplicationMap().containsKey("com.sun.faces.ApplicationAssociate");
    }

    protected boolean resolveBeanValidationAvailable() {
        boolean beanValidationAvailable;
        boolean bl = beanValidationAvailable = LangUtils.tryToLoadClassForName("javax.validation.Validation") != null;
        if (beanValidationAvailable) {
            try {
                Validation.buildDefaultValidatorFactory().getValidator();
            }
            catch (Throwable t) {
                LOGGER.log(Level.FINE, "BV not available - Could not build default ValidatorFactory.");
                beanValidationAvailable = false;
            }
        }
        return beanValidationAvailable;
    }

    protected String resolveBuildVersion() {
        String buildVersion = null;
        try (InputStream is = this.getClass().getResourceAsStream("/META-INF/maven/org.primefaces/primefaces/pom.properties");){
            Properties buildProperties = new Properties();
            buildProperties.load(is);
            buildVersion = buildProperties.getProperty("version");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "PrimeFaces version not resolvable - Could not load pom.properties.");
        }
        if (LangUtils.isValueBlank(buildVersion)) {
            buildVersion = UUID.randomUUID().toString().replace("-", "").substring(0, 10);
        }
        return buildVersion;
    }

    public boolean isBeanValidationAvailable() {
        return this.beanValidationAvailable;
    }

    public boolean isAtLeastEl22() {
        return this.atLeastEl22;
    }

    public boolean isAtLeastJsf23() {
        return this.atLeastJsf23;
    }

    public boolean isAtLeastJsf22() {
        return this.atLeastJsf22;
    }

    public boolean isAtLeastJsf21() {
        return this.atLeastJsf21;
    }

    public boolean isAtLeastServlet30() {
        return this.atLeastServlet30;
    }

    public boolean isMojarra() {
        return this.mojarra;
    }

    public boolean isAtLeastBv11() {
        return this.atLeastBv11;
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    public boolean isHtmlSanitizerAvailable() {
        return this.htmlSanitizerAvailable;
    }
}

