/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model.menu;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.primefaces.model.menu.MenuColumn;
import org.primefaces.model.menu.MenuElement;

public class DefaultMenuColumn
implements MenuColumn,
Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String style;
    private String styleClass;
    private List<MenuElement> elements = new ArrayList<MenuElement>();
    private boolean rendered = true;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    @Override
    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    @Override
    public boolean isRendered() {
        return this.rendered;
    }

    public void setRendered(boolean rendered) {
        this.rendered = rendered;
    }

    @Override
    public List<MenuElement> getElements() {
        return this.elements;
    }

    public void setElements(List<MenuElement> elements) {
        this.elements = elements;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DefaultMenuColumn column = new DefaultMenuColumn();

        private Builder() {
        }

        public Builder id(String id) {
            this.column.setId(id);
            return this;
        }

        public Builder style(String style) {
            this.column.setStyle(style);
            return this;
        }

        public Builder styleClass(String styleClass) {
            this.column.setStyleClass(styleClass);
            return this;
        }

        public Builder elements(List<MenuElement> elements) {
            this.column.setElements(elements);
            return this;
        }

        public Builder addElement(MenuElement element) {
            this.column.getElements().add(element);
            return this;
        }

        public Builder rendered(boolean rendered) {
            this.column.setRendered(rendered);
            return this;
        }

        public DefaultMenuColumn build() {
            return this.column;
        }
    }
}

