/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.renderkit;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.LangUtils;

public abstract class SelectRenderer
extends InputRenderer {
    protected boolean isHideNoSelection(UIComponent component) {
        Object attribute = component.getAttributes().get("hideNoSelectionOption");
        return attribute != null ? (Boolean)attribute : false;
    }

    protected void addSelectItem(UIInput component, List<SelectItem> selectItems, SelectItem item, boolean hideNoSelectOption) {
        if (hideNoSelectOption && item.isNoSelectionOption()) {
            return;
        }
        selectItems.add(item);
    }

    protected List<SelectItem> getSelectItems(FacesContext context, UIInput component) {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        boolean hideNoSelectOption = this.isHideNoSelection((UIComponent)component);
        for (int i = 0; i < component.getChildCount(); ++i) {
            UISelectItems uiSelectItems;
            Object value;
            SelectItem selectItem;
            UIComponent child = (UIComponent)component.getChildren().get(i);
            if (child instanceof UISelectItem) {
                UISelectItem uiSelectItem = (UISelectItem)child;
                Object selectItemValue = uiSelectItem.getValue();
                selectItem = selectItemValue == null ? new SelectItem(uiSelectItem.getItemValue(), uiSelectItem.getItemLabel(), uiSelectItem.getItemDescription(), uiSelectItem.isItemDisabled(), uiSelectItem.isItemEscaped(), uiSelectItem.isNoSelectionOption()) : (SelectItem)selectItemValue;
                this.addSelectItem(component, selectItems, selectItem, hideNoSelectOption);
                continue;
            }
            if (!(child instanceof UISelectItems) || (value = (uiSelectItems = (UISelectItems)child).getValue()) == null) continue;
            if (value instanceof SelectItem) {
                this.addSelectItem(component, selectItems, (SelectItem)value, hideNoSelectOption);
                continue;
            }
            if (value.getClass().isArray()) {
                for (int j = 0; j < Array.getLength(value); ++j) {
                    Object item = Array.get(value, j);
                    selectItem = item instanceof SelectItem ? (SelectItem)item : this.createSelectItem(context, uiSelectItems, item, null);
                    this.addSelectItem(component, selectItems, selectItem, hideNoSelectOption);
                }
                continue;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                for (Map.Entry entry : map.entrySet()) {
                    selectItem = this.createSelectItem(context, uiSelectItems, entry.getValue(), String.valueOf(entry.getKey()));
                    this.addSelectItem(component, selectItems, selectItem, hideNoSelectOption);
                }
                continue;
            }
            if (value instanceof List && value instanceof RandomAccess) {
                List list = (List)value;
                for (int j = 0; j < list.size(); ++j) {
                    Object item = list.get(j);
                    selectItem = item instanceof SelectItem ? (SelectItem)item : this.createSelectItem(context, uiSelectItems, item, null);
                    this.addSelectItem(component, selectItems, selectItem, hideNoSelectOption);
                }
                continue;
            }
            if (!(value instanceof Collection)) continue;
            Collection collection = (Collection)value;
            for (Object item : collection) {
                selectItem = item instanceof SelectItem ? (SelectItem)item : this.createSelectItem(context, uiSelectItems, item, null);
                this.addSelectItem(component, selectItems, selectItem, hideNoSelectOption);
            }
        }
        return selectItems;
    }

    protected SelectItem createSelectItem(FacesContext context, UISelectItems uiSelectItems, Object value, Object label) {
        boolean noSelectionOption;
        String var = (String)uiSelectItems.getAttributes().get("var");
        Map attrs = uiSelectItems.getAttributes();
        Map requestMap = context.getExternalContext().getRequestMap();
        if (var != null) {
            requestMap.put(var, value);
        }
        Object itemLabelValue = attrs.get("itemLabel");
        Object itemValue = attrs.get("itemValue");
        String description = (String)attrs.get("itemDescription");
        Object itemDisabled = attrs.get("itemDisabled");
        Object itemEscaped = attrs.get("itemLabelEscaped");
        Object noSelection = attrs.get("noSelectionOption");
        if (itemValue == null) {
            itemValue = value;
        }
        if (itemLabelValue == null) {
            itemLabelValue = label;
        }
        String itemLabel = itemLabelValue == null ? String.valueOf(value) : String.valueOf(itemLabelValue);
        boolean disabled = itemDisabled != null && Boolean.parseBoolean(itemDisabled.toString());
        boolean escaped = itemEscaped == null || Boolean.parseBoolean(itemEscaped.toString());
        boolean bl = noSelectionOption = noSelection != null && Boolean.parseBoolean(noSelection.toString());
        if (var != null) {
            requestMap.remove(var);
        }
        return new SelectItem(itemValue, itemLabel, description, disabled, escaped, noSelectionOption);
    }

    protected String getOptionAsString(FacesContext context, UIComponent component, Converter converter, Object value) throws ConverterException {
        if (!(component instanceof ValueHolder)) {
            return value == null ? null : value.toString();
        }
        if (converter == null) {
            if (value == null) {
                return "";
            }
            if (value instanceof String) {
                return (String)value;
            }
            Converter implicitConverter = this.findImplicitConverter(context, component);
            return implicitConverter == null ? value.toString() : implicitConverter.getAsString(context, component, value);
        }
        return converter.getAsString(context, component, value);
    }

    protected Converter findImplicitConverter(FacesContext context, UIComponent component) {
        Class<?> valueType;
        ValueExpression ve = component.getValueExpression("value");
        if (ve != null && (valueType = ve.getType(context.getELContext())) != null) {
            if (valueType.isArray()) {
                valueType = valueType.getComponentType();
            }
            return context.getApplication().createConverter(valueType);
        }
        return null;
    }

    protected Object coerceToModelType(FacesContext ctx, Object value, Class<?> itemValueType) {
        Object newValue;
        try {
            ExpressionFactory ef = ctx.getApplication().getExpressionFactory();
            newValue = ef.coerceToType(value, itemValueType);
        }
        catch (IllegalArgumentException | ELException ele) {
            newValue = value;
        }
        return newValue;
    }

    protected boolean isSelected(FacesContext context, UIComponent component, Object itemValue, Object valueArray, Converter converter) {
        if (itemValue == null && valueArray == null) {
            return true;
        }
        if (itemValue == valueArray) {
            return true;
        }
        if (valueArray != null) {
            if (!valueArray.getClass().isArray()) {
                return valueArray.equals(itemValue);
            }
            int length = Array.getLength(valueArray);
            for (int i = 0; i < length; ++i) {
                Object value = Array.get(valueArray, i);
                if (!this.isSelectValueEqual(context, component, itemValue, value, converter)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isSelectValueEqual(FacesContext context, UIComponent component, Object itemValue, Object value, Converter converter) {
        Object compareValue;
        if (value == null && itemValue == null) {
            return true;
        }
        if (value == null ^ itemValue == null) {
            return false;
        }
        if (converter == null) {
            compareValue = this.coerceToModelType(context, itemValue, value.getClass());
        } else {
            compareValue = itemValue;
            if (compareValue instanceof String && !(value instanceof String)) {
                compareValue = converter.getAsObject(context, component, (String)compareValue);
            }
        }
        return Objects.equals(value, compareValue);
    }

    protected int countSelectItems(List<SelectItem> selectItems) {
        if (selectItems == null) {
            return 0;
        }
        int count = selectItems.size();
        for (int i = 0; i < selectItems.size(); ++i) {
            SelectItem selectItem = selectItems.get(i);
            if (!(selectItem instanceof SelectItemGroup)) continue;
            count += this.countSelectItems(((SelectItemGroup)selectItem).getSelectItems());
        }
        return count;
    }

    protected int countSelectItems(SelectItem[] selectItems) {
        if (selectItems == null) {
            return 0;
        }
        int count = selectItems.length;
        for (SelectItem selectItem : selectItems) {
            if (!(selectItem instanceof SelectItemGroup)) continue;
            count += this.countSelectItems(((SelectItemGroup)selectItem).getSelectItems());
        }
        return count;
    }

    protected List<String> validateSubmittedValues(FacesContext context, UIInput component, Object[] oldValues, String ... submittedValues) throws FacesException {
        List<String> validSubmittedValues = this.doValidateSubmittedValues(context, component, oldValues, this.getSelectItems(context, component), submittedValues);
        return validSubmittedValues;
    }

    private List<String> doValidateSubmittedValues(FacesContext context, UIInput component, Object[] oldValues, List<SelectItem> selectItems, String ... submittedValues) {
        ArrayList<String> validSubmittedValues = new ArrayList<String>();
        for (int i = 0; i < selectItems.size(); ++i) {
            SelectItem selectItem = selectItems.get(i);
            if (selectItem instanceof SelectItemGroup) {
                SelectItem[] groupItemsArray = ((SelectItemGroup)selectItem).getSelectItems();
                if (groupItemsArray == null || groupItemsArray.length <= 0) continue;
                validSubmittedValues.addAll(this.doValidateSubmittedValues(context, component, oldValues, Arrays.asList(groupItemsArray), submittedValues));
                continue;
            }
            String selectItemVal = this.getOptionAsString(context, (UIComponent)component, component.getConverter(), selectItem.getValue());
            if (selectItem.isDisabled()) {
                if (LangUtils.contains(submittedValues, selectItemVal) && !LangUtils.contains(oldValues, selectItemVal) || !LangUtils.contains(oldValues, selectItemVal)) continue;
                validSubmittedValues.add(selectItemVal);
                continue;
            }
            if (!LangUtils.contains(submittedValues, selectItemVal)) continue;
            validSubmittedValues.add(selectItemVal);
        }
        return validSubmittedValues;
    }
}

