/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.api.Widget;
import org.primefaces.config.PrimeConfiguration;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.EscapeUtils;

public class WidgetBuilder {
    protected boolean endFunction;
    protected FacesContext context;
    protected PrimeConfiguration configuration;

    public WidgetBuilder(FacesContext context, PrimeConfiguration configuration) {
        this.context = context;
        this.configuration = configuration;
    }

    protected WidgetBuilder init(String widgetClass, String widgetVar, String id, boolean endFunction) throws IOException {
        this.endFunction = endFunction;
        ResponseWriter rw = this.context.getResponseWriter();
        rw.write("PrimeFaces.cw(\"");
        rw.write(widgetClass);
        rw.write("\",\"");
        rw.write(widgetVar);
        rw.write("\",{id:\"");
        rw.write(id);
        rw.write("\"");
        return this;
    }

    public <T extends UIComponent> WidgetBuilder init(String widgetClass, T widget) throws IOException {
        return this.init(widgetClass, ((Widget)widget).resolveWidgetVar(this.context), widget.getClientId(this.context)).renderLifecycleCallbacks(widget);
    }

    @Deprecated
    public WidgetBuilder init(String widgetClass, String widgetVar, String id) throws IOException {
        this.renderScriptBlock(id);
        if (this.context.isPostback() && this.context.getPartialViewContext().isAjaxRequest() || this.configuration.isMoveScriptsToBottom()) {
            this.init(widgetClass, widgetVar, id, false);
        } else {
            this.context.getResponseWriter().write("$(function(){");
            this.init(widgetClass, widgetVar, id, true);
        }
        return this;
    }

    public <T extends UIComponent> WidgetBuilder initWithWindowLoad(String widgetClass, T widget) throws IOException {
        return this.initWithWindowLoad(widgetClass, ((Widget)widget).resolveWidgetVar(this.context), widget.getClientId(this.context)).renderLifecycleCallbacks(widget);
    }

    public WidgetBuilder initWithWindowLoad(String widgetClass, String widgetVar, String id) throws IOException {
        this.renderScriptBlock(id);
        this.context.getResponseWriter().write("$(window).on(\"load\",function(){");
        this.init(widgetClass, widgetVar, id, true);
        return this;
    }

    public <T extends UIComponent> WidgetBuilder initWithComponentLoad(String widgetClass, T widget, String targetId) throws IOException {
        return this.initWithComponentLoad(widgetClass, ((Widget)widget).resolveWidgetVar(this.context), widget.getClientId(this.context), targetId).renderLifecycleCallbacks(widget);
    }

    public WidgetBuilder initWithComponentLoad(String widgetClass, String widgetVar, String id, String targetId) throws IOException {
        this.renderScriptBlock(id);
        this.context.getResponseWriter().write("PrimeFaces.onElementLoad($(PrimeFaces.escapeClientId(\"" + targetId + "\")),function(){");
        this.init(widgetClass, widgetVar, id, true);
        return this;
    }

    protected void renderScriptBlock(String id) throws IOException {
        ResponseWriter rw = this.context.getResponseWriter();
        rw.startElement("script", null);
        rw.writeAttribute("id", (Object)(id + "_s"), null);
        rw.writeAttribute("type", (Object)"text/javascript", null);
    }

    protected WidgetBuilder renderLifecycleCallbacks(UIComponent component) throws IOException {
        Object preDestroy;
        Object postRefresh;
        Map attributes = component.getAttributes();
        Object postConstruct = attributes.get("widgetPostConstruct");
        if (postConstruct != null) {
            this.callback("postConstruct", "function(widget)", postConstruct.toString());
        }
        if ((postRefresh = attributes.get("widgetPostRefresh")) != null) {
            this.callback("postRefresh", "function(widget)", postRefresh.toString());
        }
        if ((preDestroy = attributes.get("widgetPreDestroy")) != null) {
            this.callback("preDestroy", "function(widget)", preDestroy.toString());
        }
        return this;
    }

    public WidgetBuilder selectorAttr(String name, String value) throws IOException {
        if (value != null) {
            ResponseWriter rw = this.context.getResponseWriter();
            rw.write(",");
            rw.write(name);
            rw.write(":\"");
            rw.write(ComponentUtils.escapeSelector(value));
            rw.write("\"");
        }
        return this;
    }

    public WidgetBuilder attr(String name, String value) throws IOException {
        if (value != null) {
            ResponseWriter rw = this.context.getResponseWriter();
            rw.write(",");
            rw.write(name);
            rw.write(":\"");
            rw.write(EscapeUtils.forJavaScript(value));
            rw.write("\"");
        }
        return this;
    }

    public WidgetBuilder nativeAttr(String name, String value) throws IOException {
        if (value != null) {
            ResponseWriter rw = this.context.getResponseWriter();
            rw.write(",");
            rw.write(name);
            rw.write(":");
            rw.write(value);
        }
        return this;
    }

    public WidgetBuilder nativeAttr(String name, String value, String defaultValue) throws IOException {
        if (value != null && !value.equals(defaultValue)) {
            ResponseWriter rw = this.context.getResponseWriter();
            rw.write(",");
            rw.write(name);
            rw.write(":");
            rw.write(value);
        }
        return this;
    }

    public WidgetBuilder attr(String name, Boolean value) throws IOException {
        if (value != null) {
            ResponseWriter rw = this.context.getResponseWriter();
            rw.write(",");
            rw.write(name);
            rw.write(":");
            rw.write(Boolean.toString(value));
        }
        return this;
    }

    public WidgetBuilder attr(String name, Number value) throws IOException {
        if (value != null) {
            ResponseWriter rw = this.context.getResponseWriter();
            rw.write(",");
            rw.write(name);
            rw.write(":");
            rw.write(value.toString());
        }
        return this;
    }

    public WidgetBuilder attr(String name, String value, String defaultValue) throws IOException {
        if (value != null && !value.equals(defaultValue)) {
            ResponseWriter rw = this.context.getResponseWriter();
            rw.write(",");
            rw.write(name);
            rw.write(":\"");
            rw.write(EscapeUtils.forJavaScript(value));
            rw.write("\"");
        }
        return this;
    }

    public WidgetBuilder attr(String name, double value, double defaultValue) throws IOException {
        if (value != defaultValue) {
            ResponseWriter rw = this.context.getResponseWriter();
            rw.write(",");
            rw.write(name);
            rw.write(":");
            rw.write(Double.toString(value));
        }
        return this;
    }

    public WidgetBuilder attr(String name, int value, int defaultValue) throws IOException {
        if (value != defaultValue) {
            ResponseWriter rw = this.context.getResponseWriter();
            rw.write(",");
            rw.write(name);
            rw.write(":");
            rw.write(Integer.toString(value));
        }
        return this;
    }

    public WidgetBuilder attr(String name, boolean value, boolean defaultValue) throws IOException {
        if (value != defaultValue) {
            ResponseWriter rw = this.context.getResponseWriter();
            rw.write(",");
            rw.write(name);
            rw.write(":");
            rw.write(Boolean.toString(value));
        }
        return this;
    }

    public WidgetBuilder callback(String name, String signature, String callback) throws IOException {
        if (callback != null) {
            ResponseWriter rw = this.context.getResponseWriter();
            rw.write(",");
            rw.write(name);
            rw.write(":");
            rw.write(signature);
            rw.write("{");
            rw.write(callback);
            rw.write("}");
        }
        return this;
    }

    public WidgetBuilder returnCallback(String name, String signature, String callback) throws IOException {
        if (callback != null) {
            ResponseWriter rw = this.context.getResponseWriter();
            rw.write(",");
            rw.write(name);
            rw.write(":");
            rw.write(signature);
            rw.write("{return ");
            rw.write(callback);
            rw.write("}");
        }
        return this;
    }

    public WidgetBuilder callback(String name, String callback) throws IOException {
        if (callback != null) {
            ResponseWriter rw = this.context.getResponseWriter();
            rw.write(",");
            rw.write(name);
            rw.write(":");
            rw.write(callback);
        }
        return this;
    }

    public WidgetBuilder append(String str) throws IOException {
        this.context.getResponseWriter().write(str);
        return this;
    }

    public WidgetBuilder append(char chr) throws IOException {
        this.context.getResponseWriter().write((int)chr);
        return this;
    }

    public WidgetBuilder append(Number number) throws IOException {
        this.context.getResponseWriter().write(number.toString());
        return this;
    }

    public void finish() throws IOException {
        ResponseWriter rw = this.context.getResponseWriter();
        rw.write("});");
        if (this.endFunction) {
            rw.write("});");
        }
        rw.endElement("script");
    }
}

