/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.ClasspathResourceHelper;
import com.sun.faces.application.resource.FaceletWebappResourceHelper;
import com.sun.faces.application.resource.LibraryInfo;
import com.sun.faces.application.resource.ResourceCache;
import com.sun.faces.application.resource.ResourceHelper;
import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.application.resource.VersionInfo;
import com.sun.faces.application.resource.WebappResourceHelper;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import javax.faces.application.ProjectStage;
import javax.faces.application.ResourceVisitOption;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

public class ResourceManager {
    private static final Logger LOGGER = FacesLogger.RESOURCE.getLogger();
    private static final Pattern CONFIG_MIMETYPE_PATTERN = Pattern.compile("[a-z-]*/[a-z0-9.\\*-]*");
    private FaceletWebappResourceHelper faceletWebappResourceHelper = new FaceletWebappResourceHelper();
    private ResourceHelper webappResourceHelper = new WebappResourceHelper();
    private ClasspathResourceHelper classpathResourceHelper = new ClasspathResourceHelper();
    private ResourceCache cache;
    private List<Pattern> compressableTypes;
    private ReentrantLock lock = new ReentrantLock();

    public ResourceManager(ResourceCache cache) {
        this.cache = cache;
        HashMap<String, Object> throwAwayMap = new HashMap<String, Object>();
        this.initCompressableTypes(throwAwayMap);
    }

    public ResourceManager(Map<String, Object> appMap, ResourceCache cache) {
        this.cache = cache;
        this.initCompressableTypes(appMap);
    }

    public ResourceInfo findResource(String libraryName, String resourceName, String contentType, FacesContext ctx) {
        return this.findResource(libraryName, resourceName, contentType, false, ctx);
    }

    public ResourceInfo findViewResource(String resourceName, String contentType, FacesContext facesContext) {
        List<String> contracts;
        String localePrefix = this.getLocalePrefix(facesContext);
        ResourceInfo info = this.getFromCache(resourceName, null, localePrefix, contracts = this.getResourceLibraryContracts(facesContext));
        if (info == null) {
            info = this.isCompressable(contentType, facesContext) ? this.findResourceCompressed(null, resourceName, true, localePrefix, contracts, facesContext) : this.findResourceNonCompressed(null, resourceName, true, localePrefix, contracts, facesContext);
        }
        return info;
    }

    public ResourceInfo findResource(String libraryName, String resourceName, String contentType, boolean isViewResource, FacesContext ctx) {
        List<String> contracts;
        String localePrefix = this.getLocalePrefix(ctx);
        ResourceInfo info = this.getFromCache(resourceName, libraryName, localePrefix, contracts = this.getResourceLibraryContracts(ctx));
        if (info == null) {
            info = this.isCompressable(contentType, ctx) ? this.findResourceCompressed(libraryName, resourceName, isViewResource, localePrefix, contracts, ctx) : this.findResourceNonCompressed(libraryName, resourceName, isViewResource, localePrefix, contracts, ctx);
        }
        return info;
    }

    public Stream<String> getViewResources(FacesContext facesContext, String path, int maxDepth, ResourceVisitOption ... options) {
        return this.faceletWebappResourceHelper.getViewResources(facesContext, path, maxDepth, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceInfo findResourceCompressed(String libraryName, String resourceName, boolean isViewResource, String localePrefix, List<String> contracts, FacesContext ctx) {
        ResourceInfo info = null;
        this.lock.lock();
        try {
            info = this.getFromCache(resourceName, libraryName, localePrefix, contracts);
            if (info == null && (info = this.doLookup(libraryName, resourceName, localePrefix, true, isViewResource, contracts, ctx)) != null) {
                this.addToCache(info, contracts);
            }
        }
        finally {
            this.lock.unlock();
        }
        return info;
    }

    private ResourceInfo findResourceNonCompressed(String libraryName, String resourceName, boolean isViewResource, String localePrefix, List<String> contracts, FacesContext ctx) {
        ResourceInfo info = this.doLookup(libraryName, resourceName, localePrefix, false, isViewResource, contracts, ctx);
        if (info == null && contracts != null) {
            info = this.doLookup(this.libraryNameFromContracts(libraryName, contracts), resourceName, localePrefix, false, isViewResource, contracts, ctx);
        }
        if (info != null && !info.isDoNotCache()) {
            this.addToCache(info, contracts);
        }
        return info;
    }

    private String libraryNameFromContracts(String libraryName, List<String> contracts) {
        for (String contract : contracts) {
            if (!contract.equals(libraryName)) continue;
            return null;
        }
        return libraryName;
    }

    private ResourceInfo doLookup(String libraryName, String resourceName, String localePrefix, boolean compressable, boolean isViewResource, List<String> contracts, FacesContext ctx) {
        for (String contract : contracts) {
            ResourceInfo info = this.getResourceInfo(libraryName, resourceName, localePrefix, contract, compressable, isViewResource, ctx, null);
            if (info == null) continue;
            return info;
        }
        return this.getResourceInfo(libraryName, resourceName, localePrefix, null, compressable, isViewResource, ctx, null);
    }

    private ResourceInfo getResourceInfo(String libraryName, String resourceName, String localePrefix, String contract, boolean compressable, boolean isViewResource, FacesContext ctx, LibraryInfo library) {
        String resName;
        if (libraryName != null && !ResourceManager.nameContainsForbiddenSequence(libraryName)) {
            library = this.findLibrary(libraryName, localePrefix, contract, ctx);
            if (library == null && localePrefix != null) {
                library = this.findLibrary(libraryName, null, contract, ctx);
            }
            if (library == null) {
                library = this.findLibraryOnClasspathWithZipDirectoryEntryScan(libraryName, localePrefix, contract, ctx, false);
                if (library == null && localePrefix != null) {
                    library = this.findLibraryOnClasspathWithZipDirectoryEntryScan(libraryName, null, contract, ctx, false);
                }
                if (library == null) {
                    return null;
                }
            }
        } else if (ResourceManager.nameContainsForbiddenSequence(libraryName)) {
            return null;
        }
        if (ResourceManager.nameContainsForbiddenSequence(resName = this.trimLeadingSlash(resourceName)) || !isViewResource && resName.startsWith("WEB-INF")) {
            return null;
        }
        ResourceInfo info = this.findResource(library, resourceName, localePrefix, compressable, isViewResource, ctx);
        if (info == null && localePrefix != null) {
            info = this.findResource(library, resourceName, null, compressable, isViewResource, ctx);
        }
        if (info == null && library != null && library.getHelper() instanceof WebappResourceHelper) {
            LibraryInfo altLibrary = this.classpathResourceHelper.findLibrary(libraryName, localePrefix, contract, ctx);
            if (altLibrary != null) {
                VersionInfo originalVersion = library.getVersion();
                VersionInfo altVersion = altLibrary.getVersion();
                if (originalVersion == null && altVersion == null) {
                    library = altLibrary;
                } else if (originalVersion == null && altVersion != null) {
                    library = null;
                } else if (originalVersion != null && altVersion == null) {
                    library = null;
                } else if (originalVersion.compareTo(altVersion) == 0) {
                    library = altLibrary;
                }
            }
            if (library != null && (info = this.findResource(library, resourceName, localePrefix, compressable, isViewResource, ctx)) == null && localePrefix != null) {
                info = this.findResource(library, resourceName, null, compressable, isViewResource, ctx);
            }
        }
        return info;
    }

    private String trimLeadingSlash(String s) {
        if (s.charAt(0) == '/') {
            return s.substring(1);
        }
        return s;
    }

    private static boolean nameContainsForbiddenSequence(String name) {
        boolean result = false;
        if (name != null) {
            result = (name = name.toLowerCase()).startsWith(".") || name.contains("../") || name.contains("..\\") || name.startsWith("/") || name.startsWith("\\") || name.endsWith("/") || name.contains("..%2f") || name.contains("..%5c") || name.startsWith("%2f") || name.startsWith("%5c") || name.endsWith("%2f") || name.contains("..\\u002f") || name.contains("..\\u005c") || name.startsWith("\\u002f") || name.startsWith("\\u005c") || name.endsWith("\\u002f");
        }
        return result;
    }

    private ResourceInfo getFromCache(String name, String library, String localePrefix, List<String> contracts) {
        if (this.cache == null) {
            return null;
        }
        return this.cache.get(name, library, localePrefix, contracts);
    }

    private void addToCache(ResourceInfo info, List<String> contracts) {
        if (this.cache == null) {
            return;
        }
        this.cache.add(info, contracts);
    }

    LibraryInfo findLibrary(String libraryName, String localePrefix, String contract, FacesContext ctx) {
        LibraryInfo library = this.webappResourceHelper.findLibrary(libraryName, localePrefix, contract, ctx);
        if (library == null) {
            library = this.classpathResourceHelper.findLibrary(libraryName, localePrefix, contract, ctx);
        }
        if (library == null && contract == null) {
            library = this.faceletWebappResourceHelper.findLibrary(libraryName, localePrefix, contract, ctx);
        }
        return library;
    }

    LibraryInfo findLibraryOnClasspathWithZipDirectoryEntryScan(String libraryName, String localePrefix, String contract, FacesContext ctx, boolean forceScan) {
        return this.classpathResourceHelper.findLibraryWithZipDirectoryEntryScan(libraryName, localePrefix, contract, ctx, forceScan);
    }

    private ResourceInfo findResource(LibraryInfo library, String resourceName, String localePrefix, boolean compressable, boolean skipToFaceletResourceHelper, FacesContext ctx) {
        if (library != null) {
            return library.getHelper().findResource(library, resourceName, localePrefix, compressable, ctx);
        }
        ResourceInfo resource = null;
        if (!skipToFaceletResourceHelper) {
            resource = this.webappResourceHelper.findResource(null, resourceName, localePrefix, compressable, ctx);
        }
        if (resource == null && !skipToFaceletResourceHelper) {
            resource = this.classpathResourceHelper.findResource(null, resourceName, localePrefix, compressable, ctx);
        }
        if (resource == null) {
            resource = this.faceletWebappResourceHelper.findResource(library, resourceName, localePrefix, compressable, ctx);
        }
        return resource;
    }

    ResourceInfo findResource(String resourceId) {
        String libraryName = null;
        String resourceName = null;
        int end = 0;
        int start = 0;
        end = resourceId.lastIndexOf("/");
        if (-1 != end) {
            resourceName = resourceId.substring(end + 1);
            start = resourceId.lastIndexOf("/", end - 1);
            libraryName = -1 != start ? resourceId.substring(start + 1, end) : resourceId.substring(0, end);
        }
        FacesContext context = FacesContext.getCurrentInstance();
        LibraryInfo info = this.findLibrary(libraryName, null, null, context);
        ResourceInfo resourceInfo = this.findResource(info, resourceName, libraryName, true, false, context);
        return resourceInfo;
    }

    private String getLocalePrefix(FacesContext context) {
        String localePrefix;
        block4: {
            localePrefix = null;
            localePrefix = context.getExternalContext().getRequestParameterMap().get("loc");
            if (localePrefix != null) {
                return localePrefix;
            }
            String appBundleName = context.getApplication().getMessageBundle();
            if (null != appBundleName) {
                Locale locale = null;
                locale = context.getViewRoot() != null ? context.getViewRoot().getLocale() : context.getApplication().getViewHandler().calculateLocale(context);
                try {
                    ResourceBundle appBundle = ResourceBundle.getBundle(appBundleName, locale, Util.getCurrentLoader(ResourceManager.class));
                    localePrefix = appBundle.getString("javax.faces.resource.localePrefix");
                }
                catch (MissingResourceException mre) {
                    if (!LOGGER.isLoggable(Level.FINEST)) break block4;
                    LOGGER.log(Level.FINEST, "Ignoring missing resource", mre);
                }
            }
        }
        return localePrefix;
    }

    private List<String> getResourceLibraryContracts(FacesContext context) {
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot == null) {
            String param;
            if (context.getApplication().getResourceHandler().isResourceRequest(context) && !ResourceManager.nameContainsForbiddenSequence(param = context.getExternalContext().getRequestParameterMap().get("con")) && param != null && param.trim().length() > 0) {
                return Arrays.asList(param);
            }
            return Collections.emptyList();
        }
        return context.getResourceLibraryContracts();
    }

    private boolean isCompressable(String contentType, FacesContext ctx) {
        if (contentType == null || ctx.isProjectStage(ProjectStage.Development)) {
            return false;
        }
        if (this.compressableTypes != null && !this.compressableTypes.isEmpty()) {
            for (Pattern p : this.compressableTypes) {
                boolean matches = p.matcher(contentType).matches();
                if (!matches) continue;
                return true;
            }
        }
        return false;
    }

    private void initCompressableTypes(Map<String, Object> appMap) {
        String[] values;
        WebConfiguration config = WebConfiguration.getInstance();
        String value = config.getOptionValue(WebConfiguration.WebContextInitParameter.CompressableMimeTypes);
        if (value != null && value.length() > 0 && (values = Util.split(appMap, value, ",")) != null) {
            for (String s : values) {
                String pattern = s.trim();
                if (!this.isPatternValid(pattern)) continue;
                if (pattern.endsWith("/*")) {
                    pattern = pattern.substring(0, pattern.indexOf("/*"));
                    pattern = pattern + "/[a-z0-9.-]*";
                }
                if (this.compressableTypes == null) {
                    this.compressableTypes = new ArrayList<Pattern>(values.length);
                }
                try {
                    this.compressableTypes.add(Pattern.compile(pattern));
                }
                catch (PatternSyntaxException pse) {
                    if (!LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.log(Level.WARNING, "jsf.resource.mime.type.configration.invalid", new Object[]{pattern, pse.getPattern()});
                }
            }
        }
    }

    private boolean isPatternValid(String input) {
        return CONFIG_MIMETYPE_PATTERN.matcher(input).matches();
    }
}

