package dao.impl;

import dao.AccountDAO;
import dao.CustomerDAO;
import dao.exception.PersistenceException;
import dao.impl.exception.UnableToConnectException;
import model.Account;
import model.Customer;

import java.sql.*;
import java.util.ArrayList;

public class CustomerDaoMySQLImpl implements CustomerDAO {

    private Connection connection;

    private AccountDAO accountDAO;

    public CustomerDaoMySQLImpl() throws UnableToConnectException {
        this.connection = new MySQLDbConnector().getDatabaseConnection();
        this.accountDAO = new AccountDaoMySQLImpl();
    }

    public void createCustomer(Customer customer) throws PersistenceException {
        try {
            PreparedStatement stmt = this.connection.prepareStatement(
                    "INSERT INTO customer (name, address, mobileNumber, idCardNumber, isActive) VALUES (?,?,?,?,?)");

            stmt.setString(1, customer.getName());
            stmt.setString(2, customer.getAddress());
            stmt.setString(3, customer.getMobileNumber());
            stmt.setString(4, customer.getIdCardNumber());
            stmt.setBoolean(5, customer.isActive());

            stmt.execute();
        } catch (SQLException e) {
            throw new PersistenceException(e);
        }
    }

    public ArrayList<Customer> readCustomers() throws PersistenceException {
        try {
            Statement stmt = this.connection.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT * FROM customer");

            ArrayList<Customer> customers = new ArrayList<Customer>();

            while (rs.next()) {
                customers.add(new Customer(
                    rs.getInt("id"),
                    rs.getString("name"),
                    rs.getString("address"),
                    rs.getString("mobileNumber"),
                    rs.getString("idCardNumber"),
                    rs.getBoolean("isActive")
                ));
            }

            return customers;
        } catch (SQLException e) {
            throw new PersistenceException(e);
        }
    }

    public Customer readCustomerById (int id) throws PersistenceException {
        try {
            PreparedStatement stmt = this.connection.prepareStatement("SELECT * FROM customer WHERE id=? LIMIT 1");
            stmt.setInt(1, id);

            ResultSet rs = stmt.executeQuery();
            rs.next();

            return new Customer(
                rs.getInt("id"),
                rs.getString("name"),
                rs.getString("address"),
                rs.getString("mobileNumber"),
                rs.getString("idCardNumber"),
                rs.getBoolean("isActive")
            );
        } catch (SQLException e) {
            throw new PersistenceException(e);
        }
    }

    public void updateCustomer(Customer customer) throws PersistenceException {
        try {
            if (customer.getId() == null) {
                throw new PersistenceException("Unable to update customer: id is missing.");
            }

            PreparedStatement stmt = this.connection.prepareStatement(
                    "UPDATE customer SET name=?, address=?, mobileNumber=?, idCardNumber=?, isActive=? WHERE id=?");

            stmt.setString(1, customer.getName());
            stmt.setString(2, customer.getAddress());
            stmt.setString(3, customer.getMobileNumber());
            stmt.setString(4, customer.getIdCardNumber());
            stmt.setBoolean(5, customer.isActive());
            stmt.setInt(6, customer.getId());

            stmt.execute();
        } catch (SQLException e) {
            throw new PersistenceException(e);
        }
    }

    public void deleteCustomer(Customer customer) throws PersistenceException {
        try {
            PreparedStatement stmt = this.connection.prepareStatement(
                    "UPDATE customer SET isActive=FALSE WHERE id=?");

            stmt.setInt(1, customer.getId());
            stmt.execute();

            PreparedStatement stmt2 = this.connection.prepareStatement("SELECT id FROM account WHERE customerId=? AND isActive=TRUE");
            stmt2.setInt(1, customer.getId());
            ResultSet rs = stmt2.executeQuery();

            while (rs.next()) {
                this.accountDAO.deleteAccount(
                        new Account(rs.getString("id"), 0, 0, true)
                );
            }
        } catch (SQLException e) {
            throw new PersistenceException(e);
        }
    }
}
