package dao.impl;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ResourceBundle;

import dao.impl.exception.UnableToConnectException;

final class MySQLDbConnector {
    private ResourceBundle properties;

    MySQLDbConnector() throws UnableToConnectException {
        try {
        	properties = ResourceBundle.getBundle("dao.impl.properties.database");
            this.loadDriverToMemory();
        } catch (Exception e) {
            throw new UnableToConnectException("Unable to connect to database, got: " + e.getMessage());
        }
    }

    Connection getDatabaseConnection () throws UnableToConnectException {
        try {
            return DriverManager.getConnection(this.getConnectionURL());
        } catch (SQLException e) {
            throw new UnableToConnectException("Unable to connect to database: invalid credentials given, got: " +
                    e.getMessage());
        }
    }

    private void loadDriverToMemory () throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class.forName("com.mysql.cj.jdbc.Driver").newInstance();
    }

    private String getConnectionURL () {
        return "jdbc:mysql://" +
                this.properties.getString("databaseHost") +
                "/" + this.properties.getString("databaseName") +
                "?" + "user=" + this.properties.getString("databaseUser") +
                "&" + "password=" + this.properties.getString("databasePassword") +
                "&" + "serverTimezone=" + this.properties.getString("serverTimezone");
    }
}
