package model;

import model.exception.BalanceCanNotUnderZeroException;

public class Account {
    private String id;
    private int balance;
    private int customerId;
    private boolean isActive;

    public Account(String id, int balance, int customerId, boolean isActive) {
        this.id = id;
        this.balance = balance;
        this.customerId = customerId;
        this.isActive = isActive;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getBalance() {
        return balance;
    }

    public void setBalance(int balance) throws BalanceCanNotUnderZeroException {
        this.validateBalance(balance);
        this.balance = balance;
    }

    public int getCustomerId() {
        return customerId;
    }

    public void setCustomerId(int customerId) {
        this.customerId = customerId;
    }

    public boolean isActive() {
        return isActive;
    }

    public void setActive(boolean active) {
        isActive = active;
    }

    private void validateBalance (int balance) throws BalanceCanNotUnderZeroException {
        if (balance < 0) {
            throw new BalanceCanNotUnderZeroException("Balance can not be under 0, got: " + String.valueOf(balance));
        }
    }

    @Override
    public String toString() {
        return "Account{" +
                "id='" + id + '\'' +
                ", balance=" + balance +
                ", customerId=" + customerId +
                ", isActive=" + isActive +
                '}';
    }
}
