package service.impl;

import java.util.ArrayList;
import java.util.Collection;

import dao.AccountDAO;
import dao.exception.PersistenceException;
import model.Account;
import service.AccountService;

public class AccountServiceImpl implements AccountService {

    private AccountDAO dao;

    public AccountServiceImpl(AccountDAO dao) {
        this.dao = dao;
    }

    public void createAccount(Account account) throws PersistenceException {
        dao.createAccount(account);
    }

    public Collection<Account> readAccounts() throws PersistenceException {
        return dao.readAccounts();
    }

    public Account readAccountById(String id) throws PersistenceException {
        return dao.readAccountById(id);
    }

    public Collection<String> readActiveAccountIds() throws PersistenceException {
        Collection<Account> accounts = this.readAccounts();
        Collection<String> accountIds = new ArrayList<String>();

        for (Account account : accounts) {
            if (account.isActive()) {
                accountIds.add(account.getId());
            }
        }

        return accountIds;
    }

    public void updateAccount(Account account) throws PersistenceException {
        dao.updateAccount(account);
    }

    public void withdrawFromAccount(String accountId, int amount) throws PersistenceException {
        dao.withdrawAccount(accountId, amount);
    }

    public void depositToAccount(String accountId, int amount) throws PersistenceException {
        dao.depositAccount(accountId, amount);
    }

    public void deleteAccount(Account account) throws PersistenceException {
        dao.deleteAccount(account);
    }
}
