package viewController;

import java.io.Serializable;
import java.util.Collection;

import javax.annotation.PostConstruct;
import javax.enterprise.context.SessionScoped;
import javax.inject.Named;

import dao.AccountDAO;
import dao.exception.PersistenceException;
import dao.impl.AccountDaoMySQLImpl;
import dao.impl.exception.UnableToConnectException;
import model.Account;
import service.AccountService;
import service.impl.AccountServiceImpl;

@Named
@SessionScoped
public class AccountsView implements Serializable {

    private AccountService service;

    private Collection<Account> accounts;
    private Collection<Account> filteredAccounts;

    @PostConstruct
    public void init () {
        try {
            AccountDAO dao = new AccountDaoMySQLImpl();
            this.service = new AccountServiceImpl(dao);
            this.accounts = this.service.readAccounts();
        } catch (UnableToConnectException e) {
            e.printStackTrace();
        } catch (PersistenceException e) {
            e.printStackTrace();
        }
    }

    public Collection<Account> getAccounts() throws PersistenceException {
        this.accounts = this.service.readAccounts();
        return accounts;
    }

    public void setAccounts(Collection<Account> accounts) {
        this.accounts = accounts;
    }

    public Collection<Account> getFilteredAccounts() {
        return filteredAccounts;
    }

    public void setFilteredAccounts(Collection<Account> filteredAccounts) {
        this.filteredAccounts = filteredAccounts;
    }

    public void deleteAccount (Account account) throws PersistenceException {
        this.service.deleteAccount(account);
        account.setActive(false);
    }

    public String getAccountEditRoute (Account account) {
        return "edit_account.xhtml?faces-redirect=true&id=" + account.getId();
    }
}
