package viewController;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import javax.annotation.PostConstruct;
import javax.enterprise.context.SessionScoped;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.inject.Named;

import dao.AccountDAO;
import dao.CustomerDAO;
import dao.exception.PersistenceException;
import dao.impl.AccountDaoMySQLImpl;
import dao.impl.CustomerDaoMySQLImpl;
import dao.impl.exception.UnableToConnectException;
import model.Account;
import service.AccountService;
import service.CustomerService;
import service.impl.AccountServiceImpl;
import service.impl.CustomerServiceImpl;

@Named
@SessionScoped
public class EditAccountView implements Serializable {

    private AccountService accountService;

    private CustomerService customerService;

    private Account account;

    private Boolean isNewModel;

    private HashMap<String, String> customers;

    private Map<String, String> parameters;

    @PostConstruct
    public void init () {

        try {
            AccountDAO accountDao = new AccountDaoMySQLImpl();
            this.accountService = new AccountServiceImpl(accountDao);

            CustomerDAO customerDao = new CustomerDaoMySQLImpl();
            this.customerService = new CustomerServiceImpl(customerDao);

            this.customers = this.customerService.readIdsAndCustomers();

            this.parameters = FacesContext
                    .getCurrentInstance()
                    .getExternalContext()
                    .getRequestParameterMap();

            this.isNewModel = !(this.parameters.containsKey("id"));
            this.account = this.isNewModel
                    ? new Account(null, 0, 0, true)
                    : this.accountService.readAccountById(this.parameters.get("id"));
        } catch (UnableToConnectException e) {
            e.printStackTrace();
        } catch (PersistenceException e) {
            e.printStackTrace();
        }
    }

    public Account getAccount() {
        return account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public Boolean getNewModel() {
        return isNewModel;
    }

    public void setNewModel(Boolean newModel) {
        isNewModel = newModel;
    }

    public HashMap<String, String> getCustomers() {
        return customers;
    }

    public void setCustomers(HashMap<String, String> customers) {
        this.customers = customers;
    }

    public void customerValidator(FacesContext context, UIComponent comp, Object value) throws PersistenceException {

        if (value == null) {
            ((UIInput) comp).setValid(false);
            FacesMessage message = new FacesMessage("Customer must be chosen.");
            context.addMessage(comp.getClientId(context), message);
        }
    }

    public String saveAccount (Account account) throws PersistenceException {
        if (this.isNewModel) {
            this.accountService.createAccount(account);
        } else {
            this.accountService.updateAccount(account);
        }

        return "accounts.xhtml?faces-redirect=true";
    }
}
