package viewController;

import java.io.Serializable;
import java.util.Map;

import javax.annotation.PostConstruct;
import javax.enterprise.context.SessionScoped;
import javax.faces.context.FacesContext;
import javax.inject.Named;

import dao.CustomerDAO;
import dao.exception.PersistenceException;
import dao.impl.CustomerDaoMySQLImpl;
import dao.impl.exception.UnableToConnectException;
import model.Customer;
import service.CustomerService;
import service.impl.CustomerServiceImpl;

@Named
@SessionScoped
public class EditCustomerView implements Serializable {

    private CustomerService service;

    private Customer customer;

    private boolean isNewModel;

    private Map<String, String> parameters;

    @PostConstruct
    public void init () {
        try {
            CustomerDAO dao = new CustomerDaoMySQLImpl();
            this.service = new CustomerServiceImpl(dao);

            this.parameters = FacesContext
                    .getCurrentInstance()
                    .getExternalContext()
                    .getRequestParameterMap();

            this.isNewModel = !(this.parameters.containsKey("id"));
            this.customer = this.isNewModel
                    ? new Customer(0, "", "", "", "",true)
                    : this.service.readCustomerById(Integer.valueOf(this.parameters.get("id")));
        } catch (UnableToConnectException e) {
            e.printStackTrace();
        } catch (PersistenceException e) {
            e.printStackTrace();
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public Customer getCustomer() {
        return customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public boolean isNewModel() {
        return isNewModel;
    }

    public String saveCustomer (Customer customer) throws PersistenceException {
        if (this.isNewModel) {
            this.service.createCustomer(customer);
        } else {
            this.service.updateCustomer(customer);
        }

        return "customers.xhtml?faces-redirect=true";
    }
}
