package dao;

import dao.exception.PersistenceException;
import model.Account;

import java.util.Collection;

public interface AccountDAO {
    void createAccount (Account account) throws PersistenceException;

    Collection<Account> readAccounts () throws PersistenceException;

    Account readAccountById(String id) throws PersistenceException;

    void updateAccount (Account account) throws PersistenceException;

    void withdrawAccount (String accountId, int amount) throws PersistenceException;

    void depositAccount (String accountId, int amount) throws PersistenceException;

    void deleteAccount (Account account) throws PersistenceException;
}
