package service;

import java.util.Collection;

import dao.exception.PersistenceException;
import model.Account;

public interface AccountService {
    void createAccount (Account account) throws PersistenceException;

    Collection<Account> readAccounts () throws PersistenceException;

    Account readAccountById(String id) throws PersistenceException;

    Collection<String> readActiveAccountIds () throws PersistenceException;

    void updateAccount (Account account) throws PersistenceException;

    void withdrawFromAccount (String accountId, int amount) throws PersistenceException;

    void depositToAccount (String accountId, int amount) throws PersistenceException;

    void deleteAccount (Account account) throws PersistenceException;
}
