package service;

import dao.exception.PersistenceException;
import model.Customer;

import java.util.Collection;
import java.util.HashMap;

public interface CustomerService {
    void createCustomer (Customer customer) throws PersistenceException;

    Collection<Customer> readCustomers () throws PersistenceException;

    Customer readCustomerById (int id) throws PersistenceException;

    HashMap<String, String> readIdsAndCustomers () throws PersistenceException;

    void updateCustomer (Customer customer) throws PersistenceException;

    void deleteCustomer (Customer customer) throws PersistenceException;
}
