package service.impl;

import java.util.Collection;
import java.util.HashMap;

import dao.CustomerDAO;
import dao.exception.PersistenceException;
import model.Customer;
import service.CustomerService;

public class CustomerServiceImpl implements CustomerService {

    private CustomerDAO dao;

    public CustomerServiceImpl(CustomerDAO dao) {
        this.dao = dao;
    }

    public void createCustomer(Customer customer) throws PersistenceException {
        dao.createCustomer(customer);
    }

    public Collection<Customer> readCustomers() throws PersistenceException {
        return dao.readCustomers();
    }

    public Customer readCustomerById(int id) throws PersistenceException {
        return dao.readCustomerById(id);
    }

    public HashMap<String, String> readIdsAndCustomers() throws PersistenceException {
        Collection<Customer> customers = this.readCustomers();
        HashMap<String, String> customersHashMap = new HashMap<String, String>();

        for (Customer customer : customers) {
            if (customer.isActive()) {
                customersHashMap.put(customer.getName() + " (" + customer.getId() + ")", String.valueOf(customer.getId()));
            }
        }

        return customersHashMap;
    }

    public void updateCustomer(Customer customer) throws PersistenceException {
        dao.updateCustomer(customer);
    }

    public void deleteCustomer(Customer customer) throws PersistenceException {
        dao.deleteCustomer(customer);
    }
}
