package viewController;

import java.io.Serializable;
import java.util.Collection;

import javax.annotation.PostConstruct;
import javax.enterprise.context.SessionScoped;
import javax.inject.Named;

import dao.CustomerDAO;
import dao.exception.PersistenceException;
import dao.impl.CustomerDaoMySQLImpl;
import dao.impl.exception.UnableToConnectException;
import model.Customer;
import service.CustomerService;
import service.impl.CustomerServiceImpl;

@Named
@SessionScoped
public class CustomersView implements Serializable {

    private CustomerService service;

    private Collection<Customer> customers;
    private Collection<Customer> filteredCustomers;

    @PostConstruct
    public void init () {
        try {
            CustomerDAO dao = new CustomerDaoMySQLImpl();
            this.service = new CustomerServiceImpl(dao);
            this.customers = this.service.readCustomers();
            this.filteredCustomers = customers;
        } catch (UnableToConnectException e) {
            e.printStackTrace();
        } catch (PersistenceException e) {
            e.printStackTrace();
        }
    }

    public Collection<Customer> getCustomers() throws PersistenceException {
        this.customers = this.service.readCustomers();
        return customers;
    }

    public void setCustomers(Collection<Customer> customers) {
        this.customers = customers;
    }

    public Collection<Customer> getFilteredCustomers() {
        return filteredCustomers;
    }

    public void setFilteredCustomers(Collection<Customer> filteredCustomers) {
        this.filteredCustomers = filteredCustomers;
    }

    public void deleteCustomer (Customer customer) throws PersistenceException {
        this.service.deleteCustomer(customer);
        customer.setActive(false);
    }

    public String getCustomerEditRoute (Customer customer) {
        return "edit_customer.xhtml?faces-redirect=true&id=" + String.valueOf(customer.getId());
    }
}
