package org.ait.iterator;

class HourlyWorker implements Employee {
    private double hourlyWage;

    private double hours;

    private String name;

    public HourlyWorker(String name, double w, double h) {
        this.name = name;
        setHourlyWage(w);
        setHours(h);
    }

    void setHourlyWage(double w) {
        if (w > 0)
            hourlyWage = w;
        else
            hourlyWage = 0;
    }

    void setHours(double h) {
        if (0 <= h && h < 168)
            hours = h;
        else
            hours = 0;
    }

    public String getName() {
        return name;
    }

    public double earnings() {
        return hourlyWage * hours;
    }

    public String toString() {
        return "Hourly worker: " + getName();
    }
}