package org.ait.chainofresponsibility;
/**
 * Here comes a simple example, just to show how chain of responsibility works. 
 * Whenever you spend company's money, you need get approval from your boss, 
 * or your boss's boss. Let's say, the leadership chain is:
 * 
 *    Manager-->Director-->Vice President-->President
 *    
 *    The following is a command line program to check who is responsible to approve your expenditure. 
 *    
 * @source http://www.javacamp.org/designPattern/
 *
 */
public class MainApp {
    public static void main(String[] args) throws Exception {
        //
        // Set up the chain
        // Manager-->Director-->Vice President-->President
        //
        Manager manager = new Manager();
        Director director = new Director();
        VicePresident vp = new VicePresident();
        President president = new President();
        manager.setSuccessor(director);
        director.setSuccessor(vp);
        vp.setSuccessor(president);
        //
        // Sample expanditures to test with
        //
        double[] expanditure = { 500.0, 5000.0, 11000.0, 30000.0, 20000.0 };
        //
        // Get the approval for each expanditure
        // 
        for (int i = 0; i < expanditure.length; i++) {
            double d = expanditure[i];
            System.out
                    .println("The amount to check who should approve your expenditure.");
            System.out.println("> " + d);
            manager.processRequest(new PurchaseRequest(d, "General"));
            System.out.println();
        }

    }
}
