package org.ait.singleton;

public final class RemoteConnection {
    static private String con = "jdbc:odbc:hello";
    // class loader creates at loading time
    private static RemoteConnection rc = new RemoteConnection(con);
    
    private RemoteConnection(String c) { 
        con = c;
    }
    
    public static RemoteConnection getRemoteConnection() {
        return rc;
    }
    
    public void loadData() {
        System.out.println("Data loaded");
    }
}
