/*
 * Created on 2004.06.11.
 *
 */
package org.ait.aspects.listeners;

import javax.swing.JFrame;

/**
 * @author nehez
 */
public class ListenerExample extends JFrame {
	private javax.swing.JPanel jContentPane = null;
	private javax.swing.JButton jButton1 = null;
	private javax.swing.JButton jButton = null;
	private Counter counter;
	
	public static void main(String[] args) {
		ListenerExample le = new ListenerExample();
		le.setVisible(true);
	}
	/**
	 * This is the default constructor
	 */
	public ListenerExample() {
		super();
		initialize();
	}
	
	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		counter = new Counter();
		counter.startCounting();
		
		this.setSize(300, 200);
		this.setContentPane(getJContentPane());
		this.addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent e) {
				removeListeners();
				dispose();
			}
		});
	}
	
	/**
	 * remove listener
	 */
	private void removeListeners() {

	}
	
	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private javax.swing.JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new javax.swing.JPanel();
			jContentPane.setLayout(new java.awt.BorderLayout());
			jContentPane.add(getJButton(), java.awt.BorderLayout.CENTER);
			jContentPane.add(getJButton1(), java.awt.BorderLayout.SOUTH);
		}
		return jContentPane;
	}
	
	/**
	 * This method initializes jButton
	 * 
	 * @return javax.swing.JButton
	 */
	private javax.swing.JButton getJButton() {
		if (jButton == null) {
			jButton = new javax.swing.JButton();
			jButton.setText("Show a dialog");
			jButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					CounterDialog m_dialog = new CounterDialog();
					m_dialog.setTitle("Counter Dialog");
					m_dialog.setVisible(true);
					counter.addCounterChangeListener(m_dialog);
				}
			});
		}
		return jButton;
	}
	
	/**
	 * This method initializes jButton1
	 * 
	 * @return javax.swing.JButton
	 */
	private javax.swing.JButton getJButton1() {
		if (jButton1 == null) {
			jButton1 = new javax.swing.JButton();
			jButton1.setText("Run System.gc()");
			jButton1.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					System.gc();
				}
			});
		}
		return jButton1;
	}
}
