package org.ait.aspects.threading;

import javax.swing.JFrame;

/**
 * GUI to demonstrate worker threads
 * @author nehez
 */
public class GUI extends JFrame {

	private javax.swing.JPanel jContentPane = null;

	private javax.swing.JButton jButton = null;
	/**
	 * This is the default constructor
	 */
	public GUI() {
		super();
		initialize();
	}
	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		this.setSize(300, 200);
		this.setContentPane(getJContentPane());
	}
	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private javax.swing.JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new javax.swing.JPanel();
			jContentPane.setLayout(new java.awt.BorderLayout());
			jContentPane.add(getJButton(), java.awt.BorderLayout.CENTER);
		}
		return jContentPane;
	}
	/**
	 * This method initializes jButton
	 * 
	 * @return javax.swing.JButton
	 */
	private javax.swing.JButton getJButton() {
		if(jButton == null) {
			jButton = new javax.swing.JButton();
			jButton.setText("Long time process");
			jButton.addActionListener(new java.awt.event.ActionListener() { 
				public void actionPerformed(java.awt.event.ActionEvent e) {    
					LongTimeProcess();
				}
			});
		}
		return jButton;
	}
    
    public void LongTimeProcess() {
        try {
            Thread.sleep(3000);    
        }
        catch(InterruptedException e) {
        }
        System.out.println("long time process befejezdtt!");
    }
    
    public static void main(String[] args) {
        new GUI().show();
    }
}
