package org.ait.aspects.threading;

public aspect Threading {
    
	 declare parents: GUI implements Runnable;
    
	 pointcut run() : execution(* actionPerformed(..));

	 pointcut LongTimeProcess(GUI gui) : call(* GUI.LongTimeProcess(..)) && target(gui) &&
													 cflow(run());
    
	 void around(GUI t) : LongTimeProcess(t) {
		  Runnable runnable = (Runnable) t;
		  Thread thread = new Thread(runnable);
		  thread.start();
	}
    
	 public void GUI.run() {
		  System.out.println("Thread is running");
		  this.LongTimeProcess();
	 }
}
