package org.ait.iterator;
/**
 * Employee is an interface, Manager, PieceWorker, HourlyWorker 
 * and CommissionWorker are implementation classes of interface Employee. 
 * EmployeeTest class will create a list and use a built-in iterator of 
 * ArrayList class to traverse the members of the list.
 * 
 * @author http://www.javacamp.org/designPattern/
 *
 */
class Manager implements Employee {
    private double weeklySalary;

    private String name;

    public Manager(String name, double s) {
        this.name = name;
        setWeeklySalary(s);
    }

    void setWeeklySalary(double s) {
        if (s > 0) {
            weeklySalary = s;
        } else
            weeklySalary = 0;
    }

    public double earnings() {
        return weeklySalary;
    }

    public String getName() {
        return name;
    }

    public String toString() {
        return "Manager: " + getName();
    }
}