package org.ait.smartproxy.example1;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class DoorImpl extends UnicastRemoteObject implements Door {
	private final String location;

	private boolean open = false;

	public DoorImpl(String location) throws RemoteException {
		super();
		this.location = location;
	}

	public String getLocation() throws RemoteException {
		System.out.println("remote call: getLocation()");
		return location;
	}

	public boolean isOpen() throws RemoteException {
		System.out.println("remote call: isOpen()");
		return open;
	}

	public void setOpen(boolean open) {
		this.open = open;
	}
}
