/*
 * Created on 2004.06.11.
 *
 */
package org.ait.aspects.listeners;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JFrame;

/**
 * @author nehez
 */ 
public class CounterDialog extends JFrame implements CounterChangeListener {

	private javax.swing.JPanel jContentPane = null;

	private javax.swing.JButton jButton = null;

	/**
	 * This is the default constructor
	 */
	public CounterDialog() {
		super();
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		this.setSize(300, 200);
		this.setContentPane(getJContentPane());
		this.addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent e) {
				dispose();
			}
		});
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private javax.swing.JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new javax.swing.JPanel();
			jContentPane.setLayout(new java.awt.BorderLayout());
			jContentPane.add(getJButton(), java.awt.BorderLayout.WEST);
		}
		return jContentPane;
	}

	/**
	 * This method initializes jButton
	 * 
	 * @return javax.swing.JButton
	 */
	private javax.swing.JButton getJButton() {
		if (jButton == null) {
			jButton = new javax.swing.JButton();
			jButton.setText("<<");
			jButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
				}
			});
		}
		return jButton;
	}
	
	/**
	 * listen to the counter change 
	 */
	public void counterChange(CounterEvent e) {
		jButton.setText("" + e.getCount());
	}
	
	/**
	 * let us see, how garbage collector works
	 */
	protected void finalize() throws Throwable {
		System.out.println("*********** Memory is released! **************");
	}	
}
