package org.ait.aspects.listeners;

import java.lang.reflect.Method;
import java.util.Vector;

public aspect ListenerManager {

	class CallerListenerPair {
		Object caller;
		Object listener;

		public CallerListenerPair(Object caller, Object listener) {
			this.caller = caller;
			this.listener = listener;
		}
	}

	pointcut removeListeners(Object caller) : call(* org.ait..*.dispose(..)) && target(caller);

	pointcut addCounterChangeListener(Object caller, Object listener) : 
        	call(* *.addCounterChangeListener(..)) && args(listener) && target(caller);

	private Vector m_listeners = new Vector();

	after(Object caller) : removeListeners(caller) {
		for (int i = 0; i < m_listeners.size(); i++) {
			CallerListenerPair pair = (CallerListenerPair) m_listeners.get(i);
			if (caller.equals(pair.listener)) {
				System.out.println("Removing listener: " + caller);
				try {
					Class [] listenerArg = {CounterChangeListener.class};
					Method m = pair.caller.getClass().getMethod("removeCounterChangeListener", listenerArg);
					Object [] args = {pair.listener};
					m.invoke(pair.caller, args);
				}
				catch(Exception e) {
					e.printStackTrace();
				}
				m_listeners.remove(pair);
			}
		}
	}

	after(Object caller, Object listener) : addCounterChangeListener(caller, listener) {
		System.out.println("Listener was registered: \t" + listener);
		CallerListenerPair pair = new CallerListenerPair(caller, listener);
		m_listeners.add(pair);
	}
}