package org.ait.iterator;

class CommissionWorker implements Employee {
    private double salary;

    private double commission;

    private double totalSales;

    private String name;

    public CommissionWorker(String name, double salary, double commission,
            double totalSales) {
        this.name = name;
        setSalary(salary);
        setCommission(commission);
        setTotalSales(totalSales);
    }

    void setSalary(double s) {
        if (s > 0)
            salary = s;
        else
            salary = 0;
    }

    void setCommission(double c) {
        if (c > 0)
            commission = c;
        else
            commission = 0;
    }

    void setTotalSales(double ts) {
        if (ts > 0)
            totalSales = ts;
        else
            totalSales = 0;
    }

    public String getName() {
        return name;
    }

    public double earnings() {
        return salary + commission / 100 * totalSales;
    }

    public String toString() {
        return "Commission worker:" + getName();
    }
}