package org.ait.adapter;

public class MainApp {

    //
    // To reuse classes and make new class compatible with existing ones.
    // For example, A clean system is already designed, you want to add more job
    // in,
    // the Extra interface uses adapter pattern to plug in the existing system.
    //
    // see http://www.javacamp.org/designPattern/
    //

    static void Jobs(Extra job) {
        if (job instanceof Clean)
            ((Clean) job).makeClean();
        if ((Extra) job instanceof Extra)
            ((Extra) job).takeCare();
    }

    public static void main(String[] args) {
        Extra e = new Facility();
        Jobs(e);
        Clean c1 = new Office();
        Clean c2 = new Workshop();
        c1.makeClean();
        c2.makeClean();
        e.makeClean();
    }
}
