/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.jogl.impl.macosx;

import net.java.games.jogl.GL;
import net.java.games.jogl.GLCapabilities;
import net.java.games.jogl.GLException;
import net.java.games.jogl.impl.Debug;
import net.java.games.jogl.impl.GLContext;
import net.java.games.jogl.impl.macosx.CGL;
import net.java.games.jogl.impl.macosx.MacOSXGLContext;

public class MacOSXPbufferGLContext
extends MacOSXGLContext {
    private static final boolean DEBUG = Debug.debug("MacOSXPbufferGLContext");
    protected int initWidth;
    protected int initHeight;
    private long pBuffer;
    protected int width;
    protected int height;
    private boolean created;
    private int textureTarget;
    private int texture;

    public MacOSXPbufferGLContext(GLCapabilities gLCapabilities, int n, int n2) {
        super(null, gLCapabilities, null, null);
        this.initWidth = n;
        this.initHeight = n2;
    }

    public boolean canCreatePbufferContext() {
        return false;
    }

    public GLContext createPbufferContext(GLCapabilities gLCapabilities, int n, int n2) {
        throw new GLException("Not supported");
    }

    public void bindPbufferToTexture() {
        GL gL = this.getGL();
        gL.glBindTexture(this.textureTarget, this.texture);
        CGL.setContextTextureImageToPBuffer(this.nsContext, this.pBuffer, 1028);
    }

    public void releasePbufferFromTexture() {
    }

    public void createPbuffer(long l, long l2) {
        int n;
        GL gL = this.getGL();
        this.resetGLFunctionAvailability();
        if (this.capabilities.getOffscreenRenderToTextureRectangle()) {
            this.width = this.initWidth;
            this.height = this.initHeight;
            n = 34037;
        } else {
            this.width = this.getNextPowerOf2(this.initWidth);
            this.height = this.getNextPowerOf2(this.initHeight);
            n = 3553;
        }
        this.pBuffer = CGL.createPBuffer(n, this.width, this.height);
        if (this.pBuffer == 0L) {
            throw new GLException("pbuffer creation error: CGL.createPBuffer() failed");
        }
        if (DEBUG) {
            System.err.println("Created pbuffer " + this.width + " x " + this.height);
        }
    }

    protected synchronized boolean makeCurrent(Runnable runnable) throws GLException {
        this.created = false;
        if (this.pBuffer == 0L) {
            return false;
        }
        boolean bl = super.makeCurrent(runnable);
        if (this.created) {
            boolean bl2 = this.capabilities.getOffscreenRenderToTextureRectangle();
            GL gL = this.getGL();
            if (bl2 && !gL.isExtensionAvailable("GL_EXT_texture_rectangle")) {
                System.err.println("MacOSXPbufferGLContext: WARNING: GL_EXT_texture_rectangle extension not supported; skipping requested render_to_texture_rectangle support for pbuffer");
                bl2 = false;
            }
            this.textureTarget = bl2 ? 34037 : 3553;
            int[] nArray = new int[1];
            gL.glGenTextures(1, nArray);
            this.texture = nArray[0];
            gL.glBindTexture(this.textureTarget, this.texture);
            gL.glTexParameteri(this.textureTarget, 10241, 9728);
            gL.glTexParameteri(this.textureTarget, 10240, 9728);
            gL.glTexParameteri(this.textureTarget, 10242, 33071);
            gL.glTexParameteri(this.textureTarget, 10243, 33071);
            gL.glCopyTexImage2D(this.textureTarget, 0, 6407, 0, 0, this.width, this.height, 0);
        }
        return bl;
    }

    public void destroyPBuffer() {
        if (this.pBuffer != 0L) {
            CGL.destroyPBuffer(this.nsContext, this.pBuffer);
        }
        this.pBuffer = 0L;
        if (DEBUG) {
            System.err.println("Destroyed pbuffer " + this.width + " x " + this.height);
        }
    }

    public void handleModeSwitch(long l, long l2) {
        throw new GLException("Not yet implemented");
    }

    protected boolean isOffscreen() {
        return false;
    }

    protected void destroyImpl() throws GLException {
        this.destroyPBuffer();
    }

    public void swapBuffers() throws GLException {
    }

    private int getNextPowerOf2(int n) {
        if ((n - 1 & n) == 0) {
            return n;
        }
        int n2 = 0;
        while (n > 0) {
            n >>= 1;
            ++n2;
        }
        return 1 << n2;
    }

    protected void create() {
        super.create();
        this.created = true;
        CGL.setContextPBuffer(this.nsContext, this.pBuffer);
    }
}

