/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.jogl.impl.tesselator;

import net.java.games.jogl.impl.tesselator.CachedVertex;
import net.java.games.jogl.impl.tesselator.GLUface;
import net.java.games.jogl.impl.tesselator.GLUhalfEdge;
import net.java.games.jogl.impl.tesselator.GLUmesh;
import net.java.games.jogl.impl.tesselator.GLUtesselatorImpl;

class Render {
    private static final boolean USE_OPTIMIZED_CODE_PATH = false;
    private static final RenderFan renderFan;
    private static final RenderStrip renderStrip;
    private static final RenderTriangle renderTriangle;
    private static final int SIGN_INCONSISTENT = 2;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Render() {
    }

    public static void __gl_renderMesh(GLUtesselatorImpl gLUtesselatorImpl, GLUmesh gLUmesh) {
        gLUtesselatorImpl.lonelyTriList = null;
        GLUface gLUface = gLUmesh.fHead.next;
        while (gLUface != gLUmesh.fHead) {
            gLUface.marked = false;
            gLUface = gLUface.next;
        }
        gLUface = gLUmesh.fHead.next;
        while (gLUface != gLUmesh.fHead) {
            if (gLUface.inside && !gLUface.marked) {
                Render.RenderMaximumFaceGroup(gLUtesselatorImpl, gLUface);
                if (!$assertionsDisabled && !gLUface.marked) {
                    throw new AssertionError();
                }
            }
            gLUface = gLUface.next;
        }
        if (gLUtesselatorImpl.lonelyTriList != null) {
            Render.RenderLonelyTriangles(gLUtesselatorImpl, gLUtesselatorImpl.lonelyTriList);
            gLUtesselatorImpl.lonelyTriList = null;
        }
    }

    static void RenderMaximumFaceGroup(GLUtesselatorImpl gLUtesselatorImpl, GLUface gLUface) {
        GLUhalfEdge gLUhalfEdge = gLUface.anEdge;
        FaceCount faceCount = new FaceCount();
        FaceCount faceCount2 = new FaceCount();
        faceCount.size = 1L;
        faceCount.eStart = gLUhalfEdge;
        faceCount.render = renderTriangle;
        if (!gLUtesselatorImpl.flagBoundary) {
            faceCount2 = Render.MaximumFan(gLUhalfEdge);
            if (faceCount2.size > faceCount.size) {
                faceCount = faceCount2;
            }
            faceCount2 = Render.MaximumFan(gLUhalfEdge.Lnext);
            if (faceCount2.size > faceCount.size) {
                faceCount = faceCount2;
            }
            faceCount2 = Render.MaximumFan(gLUhalfEdge.Onext.Sym);
            if (faceCount2.size > faceCount.size) {
                faceCount = faceCount2;
            }
            faceCount2 = Render.MaximumStrip(gLUhalfEdge);
            if (faceCount2.size > faceCount.size) {
                faceCount = faceCount2;
            }
            faceCount2 = Render.MaximumStrip(gLUhalfEdge.Lnext);
            if (faceCount2.size > faceCount.size) {
                faceCount = faceCount2;
            }
            faceCount2 = Render.MaximumStrip(gLUhalfEdge.Onext.Sym);
            if (faceCount2.size > faceCount.size) {
                faceCount = faceCount2;
            }
        }
        faceCount.render.render(gLUtesselatorImpl, faceCount.eStart, faceCount.size);
    }

    private static boolean Marked(GLUface gLUface) {
        return !gLUface.inside || gLUface.marked;
    }

    private static GLUface AddToTrail(GLUface gLUface, GLUface gLUface2) {
        gLUface.trail = gLUface2;
        gLUface.marked = true;
        return gLUface;
    }

    private static void FreeTrail(GLUface gLUface) {
        while (gLUface != null) {
            gLUface.marked = false;
            gLUface = gLUface.trail;
        }
    }

    static FaceCount MaximumFan(GLUhalfEdge gLUhalfEdge) {
        FaceCount faceCount = new FaceCount(0L, null, renderFan);
        GLUface gLUface = null;
        GLUhalfEdge gLUhalfEdge2 = gLUhalfEdge;
        while (!Render.Marked(gLUhalfEdge2.Lface)) {
            gLUface = Render.AddToTrail(gLUhalfEdge2.Lface, gLUface);
            ++faceCount.size;
            gLUhalfEdge2 = gLUhalfEdge2.Onext;
        }
        gLUhalfEdge2 = gLUhalfEdge;
        while (!Render.Marked(gLUhalfEdge2.Sym.Lface)) {
            gLUface = Render.AddToTrail(gLUhalfEdge2.Sym.Lface, gLUface);
            ++faceCount.size;
            gLUhalfEdge2 = gLUhalfEdge2.Sym.Lnext;
        }
        faceCount.eStart = gLUhalfEdge2;
        Render.FreeTrail(gLUface);
        return faceCount;
    }

    private static boolean IsEven(long l) {
        return (l & 1L) == 0L;
    }

    static FaceCount MaximumStrip(GLUhalfEdge gLUhalfEdge) {
        FaceCount faceCount = new FaceCount(0L, null, renderStrip);
        long l = 0L;
        long l2 = 0L;
        GLUface gLUface = null;
        GLUhalfEdge gLUhalfEdge2 = gLUhalfEdge;
        while (!Render.Marked(gLUhalfEdge2.Lface)) {
            gLUface = Render.AddToTrail(gLUhalfEdge2.Lface, gLUface);
            ++l2;
            gLUhalfEdge2 = gLUhalfEdge2.Lnext.Sym;
            if (Render.Marked(gLUhalfEdge2.Lface)) break;
            gLUface = Render.AddToTrail(gLUhalfEdge2.Lface, gLUface);
            ++l2;
            gLUhalfEdge2 = gLUhalfEdge2.Onext;
        }
        GLUhalfEdge gLUhalfEdge3 = gLUhalfEdge2;
        gLUhalfEdge2 = gLUhalfEdge;
        while (!Render.Marked(gLUhalfEdge2.Sym.Lface)) {
            gLUface = Render.AddToTrail(gLUhalfEdge2.Sym.Lface, gLUface);
            ++l;
            gLUhalfEdge2 = gLUhalfEdge2.Sym.Lnext;
            if (Render.Marked(gLUhalfEdge2.Sym.Lface)) break;
            gLUface = Render.AddToTrail(gLUhalfEdge2.Sym.Lface, gLUface);
            ++l;
            gLUhalfEdge2 = gLUhalfEdge2.Sym.Onext.Sym;
        }
        GLUhalfEdge gLUhalfEdge4 = gLUhalfEdge2;
        faceCount.size = l2 + l;
        if (Render.IsEven(l2)) {
            faceCount.eStart = gLUhalfEdge3.Sym;
        } else if (Render.IsEven(l)) {
            faceCount.eStart = gLUhalfEdge4;
        } else {
            --faceCount.size;
            faceCount.eStart = gLUhalfEdge4.Onext;
        }
        Render.FreeTrail(gLUface);
        return faceCount;
    }

    static void RenderLonelyTriangles(GLUtesselatorImpl gLUtesselatorImpl, GLUface gLUface) {
        int n = -1;
        gLUtesselatorImpl.callBeginOrBeginData(4);
        while (gLUface != null) {
            GLUhalfEdge gLUhalfEdge = gLUface.anEdge;
            do {
                if (gLUtesselatorImpl.flagBoundary) {
                    int n2;
                    int n3 = n2 = !gLUhalfEdge.Sym.Lface.inside ? 1 : 0;
                    if (n != n2) {
                        n = n2;
                        gLUtesselatorImpl.callEdgeFlagOrEdgeFlagData(n != 0);
                    }
                }
                gLUtesselatorImpl.callVertexOrVertexData(gLUhalfEdge.Org.data);
            } while ((gLUhalfEdge = gLUhalfEdge.Lnext) != gLUface.anEdge);
            gLUface = gLUface.trail;
        }
        gLUtesselatorImpl.callEndOrEndData();
    }

    public static void __gl_renderBoundary(GLUtesselatorImpl gLUtesselatorImpl, GLUmesh gLUmesh) {
        GLUface gLUface = gLUmesh.fHead.next;
        while (gLUface != gLUmesh.fHead) {
            if (gLUface.inside) {
                gLUtesselatorImpl.callBeginOrBeginData(2);
                GLUhalfEdge gLUhalfEdge = gLUface.anEdge;
                do {
                    gLUtesselatorImpl.callVertexOrVertexData(gLUhalfEdge.Org.data);
                } while ((gLUhalfEdge = gLUhalfEdge.Lnext) != gLUface.anEdge);
                gLUtesselatorImpl.callEndOrEndData();
            }
            gLUface = gLUface.next;
        }
    }

    static int ComputeNormal(GLUtesselatorImpl gLUtesselatorImpl, double[] dArray, boolean bl) {
        CachedVertex[] cachedVertexArray = gLUtesselatorImpl.cache;
        int n = gLUtesselatorImpl.cacheCount;
        double[] dArray2 = new double[3];
        int n2 = 0;
        if (!bl) {
            dArray[2] = 0.0;
            dArray[1] = 0.0;
            dArray[0] = 0.0;
        }
        int n3 = 1;
        double d = cachedVertexArray[n3].coords[0] - cachedVertexArray[0].coords[0];
        double d2 = cachedVertexArray[n3].coords[1] - cachedVertexArray[0].coords[1];
        double d3 = cachedVertexArray[n3].coords[2] - cachedVertexArray[0].coords[2];
        while (++n3 < n) {
            double d4 = d;
            double d5 = d2;
            double d6 = d3;
            d = cachedVertexArray[n3].coords[0] - cachedVertexArray[0].coords[0];
            d2 = cachedVertexArray[n3].coords[1] - cachedVertexArray[0].coords[1];
            d3 = cachedVertexArray[n3].coords[2] - cachedVertexArray[0].coords[2];
            dArray2[0] = d5 * d3 - d6 * d2;
            dArray2[1] = d6 * d - d4 * d3;
            dArray2[2] = d4 * d2 - d5 * d;
            double d7 = dArray2[0] * dArray[0] + dArray2[1] * dArray[1] + dArray2[2] * dArray[2];
            if (!bl) {
                if (d7 >= 0.0) {
                    dArray[0] = dArray[0] + dArray2[0];
                    dArray[1] = dArray[1] + dArray2[1];
                    dArray[2] = dArray[2] + dArray2[2];
                    continue;
                }
                dArray[0] = dArray[0] - dArray2[0];
                dArray[1] = dArray[1] - dArray2[1];
                dArray[2] = dArray[2] - dArray2[2];
                continue;
            }
            if (d7 == 0.0) continue;
            if (d7 > 0.0) {
                if (n2 < 0) {
                    return 2;
                }
                n2 = 1;
                continue;
            }
            if (n2 > 0) {
                return 2;
            }
            n2 = -1;
        }
        return n2;
    }

    public static boolean __gl_renderCache(GLUtesselatorImpl gLUtesselatorImpl) {
        int n;
        CachedVertex[] cachedVertexArray = gLUtesselatorImpl.cache;
        int n2 = gLUtesselatorImpl.cacheCount;
        double[] dArray = new double[3];
        if (gLUtesselatorImpl.cacheCount < 3) {
            return true;
        }
        dArray[0] = gLUtesselatorImpl.normal[0];
        dArray[1] = gLUtesselatorImpl.normal[1];
        dArray[2] = gLUtesselatorImpl.normal[2];
        if (dArray[0] == 0.0 && dArray[1] == 0.0 && dArray[2] == 0.0) {
            Render.ComputeNormal(gLUtesselatorImpl, dArray, false);
        }
        if ((n = Render.ComputeNormal(gLUtesselatorImpl, dArray, true)) == 2) {
            return false;
        }
        return n == 0;
    }

    static {
        $assertionsDisabled = !Render.class.desiredAssertionStatus();
        renderFan = new RenderFan();
        renderStrip = new RenderStrip();
        renderTriangle = new RenderTriangle();
    }

    private static class RenderStrip
    implements renderCallBack {
        static final /* synthetic */ boolean $assertionsDisabled;

        private RenderStrip() {
        }

        public void render(GLUtesselatorImpl gLUtesselatorImpl, GLUhalfEdge gLUhalfEdge, long l) {
            gLUtesselatorImpl.callBeginOrBeginData(5);
            gLUtesselatorImpl.callVertexOrVertexData(gLUhalfEdge.Org.data);
            gLUtesselatorImpl.callVertexOrVertexData(gLUhalfEdge.Sym.Org.data);
            while (!Render.Marked(gLUhalfEdge.Lface)) {
                gLUhalfEdge.Lface.marked = true;
                --l;
                gLUhalfEdge = gLUhalfEdge.Lnext.Sym;
                gLUtesselatorImpl.callVertexOrVertexData(gLUhalfEdge.Org.data);
                if (Render.Marked(gLUhalfEdge.Lface)) break;
                gLUhalfEdge.Lface.marked = true;
                --l;
                gLUhalfEdge = gLUhalfEdge.Onext;
                gLUtesselatorImpl.callVertexOrVertexData(gLUhalfEdge.Sym.Org.data);
            }
            if (!$assertionsDisabled && l != 0L) {
                throw new AssertionError();
            }
            gLUtesselatorImpl.callEndOrEndData();
        }

        static {
            $assertionsDisabled = !(class$net$java$games$jogl$impl$tesselator$Render == null ? (class$net$java$games$jogl$impl$tesselator$Render = Render.class$("net.java.games.jogl.impl.tesselator.Render")) : class$net$java$games$jogl$impl$tesselator$Render).desiredAssertionStatus();
        }
    }

    private static class RenderFan
    implements renderCallBack {
        static final /* synthetic */ boolean $assertionsDisabled;

        private RenderFan() {
        }

        public void render(GLUtesselatorImpl gLUtesselatorImpl, GLUhalfEdge gLUhalfEdge, long l) {
            gLUtesselatorImpl.callBeginOrBeginData(6);
            gLUtesselatorImpl.callVertexOrVertexData(gLUhalfEdge.Org.data);
            gLUtesselatorImpl.callVertexOrVertexData(gLUhalfEdge.Sym.Org.data);
            while (!Render.Marked(gLUhalfEdge.Lface)) {
                gLUhalfEdge.Lface.marked = true;
                --l;
                gLUhalfEdge = gLUhalfEdge.Onext;
                gLUtesselatorImpl.callVertexOrVertexData(gLUhalfEdge.Sym.Org.data);
            }
            if (!$assertionsDisabled && l != 0L) {
                throw new AssertionError();
            }
            gLUtesselatorImpl.callEndOrEndData();
        }

        static {
            $assertionsDisabled = !(class$net$java$games$jogl$impl$tesselator$Render == null ? (class$net$java$games$jogl$impl$tesselator$Render = Render.class$("net.java.games.jogl.impl.tesselator.Render")) : class$net$java$games$jogl$impl$tesselator$Render).desiredAssertionStatus();
        }
    }

    private static class RenderTriangle
    implements renderCallBack {
        static final /* synthetic */ boolean $assertionsDisabled;

        private RenderTriangle() {
        }

        public void render(GLUtesselatorImpl gLUtesselatorImpl, GLUhalfEdge gLUhalfEdge, long l) {
            if (!$assertionsDisabled && l != 1L) {
                throw new AssertionError();
            }
            gLUtesselatorImpl.lonelyTriList = Render.AddToTrail(gLUhalfEdge.Lface, gLUtesselatorImpl.lonelyTriList);
        }

        static {
            $assertionsDisabled = !(class$net$java$games$jogl$impl$tesselator$Render == null ? (class$net$java$games$jogl$impl$tesselator$Render = Render.class$("net.java.games.jogl.impl.tesselator.Render")) : class$net$java$games$jogl$impl$tesselator$Render).desiredAssertionStatus();
        }
    }

    private static interface renderCallBack {
        public void render(GLUtesselatorImpl var1, GLUhalfEdge var2, long var3);
    }

    private static class FaceCount {
        long size;
        GLUhalfEdge eStart;
        renderCallBack render;

        public FaceCount() {
        }

        public FaceCount(long l, GLUhalfEdge gLUhalfEdge, renderCallBack renderCallBack2) {
            this.size = l;
            this.eStart = gLUhalfEdge;
            this.render = renderCallBack2;
        }
    }
}

