import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.JFrame;

import net.java.games.jogl.GL;
import net.java.games.jogl.GLCanvas;
import net.java.games.jogl.GLCapabilities;
import net.java.games.jogl.GLDrawable;
import net.java.games.jogl.GLDrawableFactory;
import net.java.games.jogl.GLEventListener;

public class KrRajzols extends JFrame implements GLEventListener {

    public KrRajzols() {
        super ("Krrajzols");
        
        GLCapabilities capabilities = new GLCapabilities();
        
        GLCanvas canvas = GLDrawableFactory.getFactory().createGLCanvas(capabilities);
        
        canvas.addGLEventListener(this);
        
        getContentPane().add(canvas, BorderLayout.CENTER);
        
        pack();
    }
    
    public static void main(String [] args) {
    	new KrRajzols().show();
    }
    
    public Dimension getPreferredSize () {
        return new Dimension (500, 500);
    }
    
	/* (non-Javadoc)
	 * @see net.java.games.jogl.GLEventListener#init(net.java.games.jogl.GLDrawable)
	 */
	public void init(GLDrawable arg0) {	
	}

	/* (non-Javadoc)
	 * @see net.java.games.jogl.GLEventListener#display(net.java.games.jogl.GLDrawable)
	 */
	public void display(GLDrawable pGL) {
		GL gl = pGL.getGL();
		gl.glClearColor (0.5f, 0.5f, 0.5f, 0.0f);		// szrke szn
		gl.glClear (GL.GL_COLOR_BUFFER_BIT);		// kpernytrls

		int points = 100;
		gl.glBegin(GL.GL_LINE_LOOP);

		for (int i = 0; i < points; i++)
			{
			double szog = 2 * Math.PI * i / points;
			gl.glVertex2d(Math.cos(szog), Math.sin(szog));
			} 
		gl.glEnd();	
	}

	/* (non-Javadoc)
	 * @see net.java.games.jogl.GLEventListener#reshape(net.java.games.jogl.GLDrawable, int, int, int, int)
	 */
	public void reshape(GLDrawable arg0, int arg1, int arg2, int arg3, int arg4) {
	}

	/* (non-Javadoc)
	 * @see net.java.games.jogl.GLEventListener#displayChanged(net.java.games.jogl.GLDrawable, boolean, boolean)
	 */
	public void displayChanged(GLDrawable arg0, boolean arg1, boolean arg2) {
	}

}
