package org.ait.pldk;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Random;

import net.java.games.jogl.Animator;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLDrawable;
import net.java.games.jogl.GLU;
import net.java.games.jogl.util.GLUT;

import org.ait.glbase.GLgeneral;

public class Gmbk extends GLgeneral implements KeyListener {
	GLUT glut = new GLUT();

	final static int GOMBOKSZAMA = 1000;

	float fvGombPos[][];

	float fHajoZ = -500.0f;

	float fHajoY = 0.0f;

	public Gmbk() {
		super("Gmbk");
		addKeyListener(this);
		Random rnd = new Random();
		fvGombPos = new float[GOMBOKSZAMA][3];

		for (int i = 0; i < GOMBOKSZAMA; i++) {
			fvGombPos[i][0] = (float) rnd.nextFloat() * 1000.0f - 500f;
			fvGombPos[i][1] = (float) rnd.nextFloat() * 1000.0f - 500f;
			fvGombPos[i][2] = -(float) rnd.nextFloat() * 10000.0f; 
		}
		Animator animator = new Animator(canvas);
		animator.start();
	}

	public void reshape(GLDrawable pGl, int x, int y, int w, int h) {
		GL gl = pGl.getGL();
		gl.glViewport(0, 0, w, h);
		gl.glMatrixMode(GL.GL_PROJECTION);
		gl.glLoadIdentity();
		GLU glu = pGl.getGLU();
		glu.gluPerspective(60.0, 1.0, 10.0, 1000.0);
		gl.glMatrixMode(GL.GL_MODELVIEW);
	}

	public void display(GLDrawable pGL) {
		GL gl = pGL.getGL();
		gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
		gl.glClear(GL.GL_COLOR_BUFFER_BIT);
		gl.glColor3f(1.0f, 1.0f, 1.0f);
		gl.glLoadIdentity(); // egysgmtrix
		//
		// nzpont transzformci viewing transformation
		// 
		gl.glRotatef(fHajoY, 0.0f, 1.0f, 0.0f);
		gl.glTranslatef(-150.0f, -150.0f, fHajoZ);
		//
		// model transformacio
		//
		for (int i = 0; i < GOMBOKSZAMA; i++) {
			/*
			 * glPushMatrix();
			 * glTranslatef(fvGombPos[i][0],fvGombPos[i][1],fvGombPos[i][2]);
			 * glutWireSphere(2.0f, 10, 10); 
			 * glPopMatrix();
			 */

			gl.glTranslatef(fvGombPos[i][0], fvGombPos[i][1], fvGombPos[i][2]);

			glut.glutWireSphere(pGL.getGLU(), 2.0f, 10, 10);

			gl.glTranslatef(-fvGombPos[i][0], -fvGombPos[i][1],
					-fvGombPos[i][2]);
		}
	}

	public static void main(String[] args) {
		new Gmbk().show();
	}

	public void keyPressed(KeyEvent e) {
		switch (e.getKeyChar()) {
		case 'w':
			fHajoZ += 10.0f;
			break;
		case 's':
			fHajoZ -= 10.0f;
			break;
		case 'a':
			fHajoY--;
			break;
		case 'd':
			fHajoY++;
			break;
		}
	}

	public void keyReleased(KeyEvent e) {
	}

	public void keyTyped(KeyEvent e) {
	}
}