
import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.JFrame;

import net.java.games.jogl.GL;
import net.java.games.jogl.GLCanvas;
import net.java.games.jogl.GLCapabilities;
import net.java.games.jogl.GLDrawable;
import net.java.games.jogl.GLDrawableFactory;
import net.java.games.jogl.GLEventListener;

public class Szakaszok extends JFrame implements GLEventListener {
	public Szakaszok() {
		super("Szakaszok");

		GLCapabilities capabilities = new GLCapabilities();

		GLCanvas canvas = GLDrawableFactory.getFactory().createGLCanvas(
				capabilities);

		canvas.addGLEventListener(this);

		getContentPane().add(canvas, BorderLayout.CENTER);

		pack();
	}

	public static void main(String[] args) {
		new Szakaszok().show();
	}

	public Dimension getPreferredSize() {
		return new Dimension(500, 500);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.java.games.jogl.GLEventListener#display(net.java.games.jogl.GLDrawable)
	 */
	public void display(GLDrawable pGL) {
		GL gl = pGL.getGL();
		int i;

		gl.glClear(GL.GL_COLOR_BUFFER_BIT);

		/* select white for all lines */
		gl.glColor3f(1.0f, 1.0f, 1.0f);

		/* in 1st row, 3 lines, each with a different stipple */
		gl.glEnable(GL.GL_LINE_STIPPLE);

		gl.glLineStipple(1, (short) 0x0101); /* dotted */
		drawOneLine(gl, 50.0, 125.0, 150.0, 125.0);
		gl.glLineStipple(1, (short) 0x00FF); /* dashed */
		drawOneLine(gl, 150.0, 125.0, 250.0, 125.0);
		gl.glLineStipple(1, (short) 0x1C47); /* dash/dot/dash */
		drawOneLine(gl, 250.0, 125.0, 350.0, 125.0);

		/* in 2nd row, 3 wide lines, each with different stipple */
		gl.glLineWidth(5.0f);
		gl.glLineStipple(1, (short)0x0101); /* dotted */
		drawOneLine(gl, 50.0, 100.0, 150.0, 100.0);
		gl.glLineStipple(1, (short)0x00FF); /* dashed */
		drawOneLine(gl, 150.0, 100.0, 250.0, 100.0);
		gl.glLineStipple(1, (short)0x1C47); /* dash/dot/dash */
		drawOneLine(gl, 250.0, 100.0, 350.0, 100.0);
		gl.glLineWidth(1.0f);

		/* in 3rd row, 6 lines, with dash/dot/dash stipple */
		/* as part of a single connected line strip */
		gl.glLineStipple(1, (short)0x1C47); /* dash/dot/dash */
		gl.glBegin(GL.GL_LINE_STRIP);
		for (i = 0; i < 7; i++) {
			gl.glVertex2d(50.0 + ((float) i * 50.0), 75.0);
		}
		gl.glEnd();

		/* in 4th row, 6 independent lines with same stipple */
		for (i = 0; i < 6; i++) {
			drawOneLine(gl, 50.0 + ((float) i * 50.0), 50.0,
					50.0 + ((float) (i + 1) * 50.0), 50.0);
		}

		/* in 5th row, 1 line, with dash/dot/dash stipple */
		/* and a stipple repeat factor of 5 */
		gl.glLineStipple(5, (short)0x1C47); /* dash/dot/dash */
		drawOneLine(gl, 50.0, 25.0, 350.0, 25.0);

		gl.glDisable(GL.GL_LINE_STIPPLE);
		gl.glFlush();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.java.games.jogl.GLEventListener#reshape(net.java.games.jogl.GLDrawable,
	 *      int, int, int, int)
	 */
	public void reshape(GLDrawable pGL, int x, int y, int w, int h) {
		GL gl = pGL.getGL();
		gl.glViewport(0, 0, w, h);
		gl.glMatrixMode(GL.GL_PROJECTION);
		gl.glLoadIdentity();
		gl.glOrtho(0.0, (double) w, 0.0, (double) h, -1.0, 1.0);
	}

	private void drawOneLine(GL gl, double x1, double y1, double x2, double y2) {
		gl.glBegin(GL.GL_LINES);
		gl.glVertex2d((x1), (y1));
		gl.glVertex2d((x2), (y2));
		gl.glEnd();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.java.games.jogl.GLEventListener#displayChanged(net.java.games.jogl.GLDrawable,
	 *      boolean, boolean)
	 */
	public void displayChanged(GLDrawable arg0, boolean arg1, boolean arg2) {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.java.games.jogl.GLEventListener#init(net.java.games.jogl.GLDrawable)
	 */
	public void init(GLDrawable pGL) {
		GL gl = pGL.getGL();
		gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
		gl.glShadeModel(GL.GL_FLAT);
	}

}