/*
 * Created on 2005.02.19.
 */
package org.ait.millingsimulator;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;

import javax.swing.JFrame;

import net.java.games.jogl.Animator;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLCanvas;
import net.java.games.jogl.GLCapabilities;
import net.java.games.jogl.GLDrawable;
import net.java.games.jogl.GLDrawableFactory;
import net.java.games.jogl.GLEventListener;

/**
 * @author nehez
 */
public class Grid extends JFrame implements GLEventListener, MouseListener,
		MouseMotionListener, WindowListener {

	Animator animator;

	public Grid(int size, float isoLevel) {
		super("MillingSimulator");

		mSize = size;
		mIsoLevel = isoLevel;

		long start = System.currentTimeMillis();

		System.out.println("calculate: ");
		allocateTables();

		long end = System.currentTimeMillis();
		long elapsedTime = end - start;
		System.out.println("allocateTables():" + elapsedTime);
		start = System.currentTimeMillis();

		calculateGrids(); // go

		end = System.currentTimeMillis();
		elapsedTime = end - start;
		System.out.println("calculateGrids():" + elapsedTime);
		start = System.currentTimeMillis();

		connectGrids();
		end = System.currentTimeMillis();
		elapsedTime = end - start;
		System.out.println("connectGrids():" + elapsedTime);


		GLCapabilities capabilities = new GLCapabilities();

		GLCanvas canvas = GLDrawableFactory.getFactory().createGLCanvas(
				capabilities);

		canvas.addGLEventListener(this);
		getContentPane().add(canvas, BorderLayout.CENTER);

		pack();
		start = System.currentTimeMillis();
		
		createTriangles();
		end = System.currentTimeMillis();
		elapsedTime = end - start;
		System.out.println("createTriangles():" + elapsedTime);

		System.out.println("Number of triangles:" + mTriangles.size());

		animator = new Animator(canvas);
		animator.start();
		addWindowListener(this);		
	}

	public Dimension getPreferredSize() {
		return new Dimension(500, 500);
	}

	void polygoniseAndInsert(GridCell grid, float isoLevel) {
		int cubeIndex = 0;
		if (grid.point[0].val < isoLevel)
			cubeIndex |= 1;
		if (grid.point[1].val < isoLevel)
			cubeIndex |= 2;
		if (grid.point[2].val < isoLevel)
			cubeIndex |= 4;
		if (grid.point[3].val < isoLevel)
			cubeIndex |= 8;
		if (grid.point[4].val < isoLevel)
			cubeIndex |= 16;
		if (grid.point[5].val < isoLevel)
			cubeIndex |= 32;
		if (grid.point[6].val < isoLevel)
			cubeIndex |= 64;
		if (grid.point[7].val < isoLevel)
			cubeIndex |= 128;

		if (MarchingCubesConsts.EdgeTable[cubeIndex] == 0) {
			return;
		}

		Point vertices[] = new Point[12];

		for (int xx = 0; xx < 12; xx++) {
			vertices[xx] = new Point();
		}

		if ((MarchingCubesConsts.EdgeTable[cubeIndex] & 1) == 1) {
			vertices[0] = interpolate(isoLevel, grid.point[0], grid.point[1]);
		}
		short s = 0xfff;

		if ((MarchingCubesConsts.EdgeTable[cubeIndex] & 2) == 2) {
			vertices[1] = interpolate(isoLevel, grid.point[1], grid.point[2]);
		}
		if ((MarchingCubesConsts.EdgeTable[cubeIndex] & 4) == 4) {
			vertices[2] = interpolate(isoLevel, grid.point[2], grid.point[3]);
		}
		if ((MarchingCubesConsts.EdgeTable[cubeIndex] & 8) == 8) {
			vertices[3] = interpolate(isoLevel, grid.point[3], grid.point[0]);
		}
		if ((MarchingCubesConsts.EdgeTable[cubeIndex] & 16) == 16) {
			vertices[4] = interpolate(isoLevel, grid.point[4], grid.point[5]);
		}
		if ((MarchingCubesConsts.EdgeTable[cubeIndex] & 32) == 32) {
			vertices[5] = interpolate(isoLevel, grid.point[5], grid.point[6]);
		}
		if ((MarchingCubesConsts.EdgeTable[cubeIndex] & 64) == 64) {
			vertices[6] = interpolate(isoLevel, grid.point[6], grid.point[7]);
		}
		if ((MarchingCubesConsts.EdgeTable[cubeIndex] & 128) == 128) {
			vertices[7] = interpolate(isoLevel, grid.point[7], grid.point[4]);
		}
		if ((MarchingCubesConsts.EdgeTable[cubeIndex] & 256) == 256) {
			vertices[8] = interpolate(isoLevel, grid.point[0], grid.point[4]);
		}
		if ((MarchingCubesConsts.EdgeTable[cubeIndex] & 512) == 512) {
			vertices[9] = interpolate(isoLevel, grid.point[1], grid.point[5]);
		}
		if ((MarchingCubesConsts.EdgeTable[cubeIndex] & 1024) == 1024) {
			vertices[10] = interpolate(isoLevel, grid.point[2], grid.point[6]);
		}
		if ((MarchingCubesConsts.EdgeTable[cubeIndex] & 2048) == 2048) {
			vertices[11] = interpolate(isoLevel, grid.point[3], grid.point[7]);
		}

		for (int i = 0; MarchingCubesConsts.TriTable[cubeIndex][i] != -1; i += 3) {
			Triangle tri = new Triangle();
			tri.point[0] = vertices[MarchingCubesConsts.TriTable[cubeIndex][i]];
			tri.point[1] = vertices[MarchingCubesConsts.TriTable[cubeIndex][i + 1]];
			tri.point[2] = vertices[MarchingCubesConsts.TriTable[cubeIndex][i + 2]];
			calculateNormal(tri);
			mTriangles.add(tri);
		}
	}

	public void display(GLDrawable pGL) {
		GL gl = pGL.getGL();

		gl.glClearColor(0.2f, 0.2f, 0.2f, 0.0f); // szrke szin

		gl.glClear(GL.GL_COLOR_BUFFER_BIT | GL.GL_DEPTH_BUFFER_BIT);

		gl.glLoadIdentity();

		
		gl.glTranslatef(0.0f, 0.0f, -MillingSimulator.zoom * 100.0f);
		
		gl.glRotatef(MillingSimulator.xrot, 1.0f, 0.0f, 0.0f);
		gl.glRotatef(-MillingSimulator.yrot, 0.0f, 0.0f, 1.0f);
		
		long NumofTriangles = 0;
		gl.glBegin(GL.GL_TRIANGLES);

		for (int i = 0; i < mTriangles.size(); i++) {
			Triangle tri = (Triangle) mTriangles.get(i);
			gl.glNormal3f(tri.nx, tri.ny, tri.nz);
			for (int j = 0; j < 3; j++) {
				gl.glVertex3f(tri.point[j].x,tri.point[j].y,tri.point[j].z);
			}

		}
		gl.glEnd();		
	}

	Point interpolate(float isoLevel, GridPoint gp1, GridPoint gp2) {
		float mu;
		Point p = new Point();
		mu = (isoLevel - gp1.val) / (gp2.val - gp1.val);
		p.x = gp1.x + mu * (gp2.x - gp1.x);
		p.y = gp1.y + mu * (gp2.y - gp1.y);
		p.z = gp1.z + mu * (gp2.z - gp1.z);
		return p;
	}

	private void allocateTables() {
		mGridPoints = new GridPoint[mSize + 1][mSize + 1][mSize + 1];
		mGridCells = new GridCell[mSize][mSize][mSize];
	}

	int mSize;

	float mIsoLevel;

	GridPoint mGridPoints[][][];

	GridCell mGridCells[][][];

	ArrayList mTriangles = new ArrayList();

	public void calculateGrids() {
		if (mGridPoints == null || mGridCells == null) {
			return;
		}
		for (int i = 0; i < mSize + 1; i++) {
			for (int j = 0; j < mSize + 1; j++) {
				for (int k = 0; k < mSize + 1; k++) {
					GridPoint gridPoint = new GridPoint();
					gridPoint.x = (float) (2 * i) / (float) (mSize) - 1.0f;
					gridPoint.y = (float) (2 * j) / (float) (mSize) - 1.0f;
					gridPoint.z = (float) (2 * k) / (float) (mSize) - 1.0f;
					gridPoint.val = MillingSimulator.workpiece(gridPoint.x,
							gridPoint.y, gridPoint.z);
					mGridPoints[i][j][k] = gridPoint;
				}
			}
		}
	}

	public void connectGrids() {
		if (mGridPoints == null || mGridCells == null) {
			return;
		}
		for (int i = 0; i < mSize; i++) {
			for (int j = 0; j < mSize; j++) {
				for (int k = 0; k < mSize; k++) {
					GridCell gridCell = new GridCell();
					gridCell.point[0] = mGridPoints[i][j][k];
					gridCell.point[1] = mGridPoints[i + 1][j][k];
					gridCell.point[2] = mGridPoints[i + 1][j][k + 1];
					gridCell.point[3] = mGridPoints[i][j][k + 1];
					gridCell.point[4] = mGridPoints[i][j + 1][k];
					gridCell.point[5] = mGridPoints[i + 1][j + 1][k];
					gridCell.point[6] = mGridPoints[i + 1][j + 1][k + 1];
					gridCell.point[7] = mGridPoints[i][j + 1][k + 1];
					mGridCells[i][j][k] = gridCell;
				}
			}
		}
	}

	void calculateNormal(Triangle p_Tri) {
		float a[] = new float[3];
		float b[] = new float[3];
		float length;
		a[0] = p_Tri.point[0].x - p_Tri.point[1].x;
		a[1] = p_Tri.point[0].y - p_Tri.point[1].y;
		a[2] = p_Tri.point[0].z - p_Tri.point[1].z;
		b[0] = p_Tri.point[0].x - p_Tri.point[2].x;
		b[1] = p_Tri.point[0].y - p_Tri.point[2].y;
		b[2] = p_Tri.point[0].z - p_Tri.point[2].z;
		p_Tri.nx = a[1] * b[2] - b[1] * a[2];
		p_Tri.ny = b[0] * a[2] - a[0] * b[2];
		p_Tri.nz = a[0] * b[1] - b[0] * a[1];
		length = 1.0f / (float) Math.sqrt((double) (p_Tri.nx * p_Tri.nx
				+ p_Tri.ny * p_Tri.ny + p_Tri.nz
				* p_Tri.nz));
		p_Tri.nx *= length;
		p_Tri.ny *= length;
		p_Tri.nz *= length;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.java.games.jogl.GLEventListener#init(net.java.games.jogl.GLDrawable)
	 */
	public void init(GLDrawable drawable) {
		float AmbLight[] = { 0.3f, 0.3f, 0.5f, 0.3f };
		float DifLight[] = { 0.6f, 0.6f, 0.6f, 0.6f };
		float LightPos[] = { 10.0f, 13.0f, 15.0f, 0.0f };

		GL gl = drawable.getGL();
		gl.glClearDepth(1.0f);
		gl.glEnable(GL.GL_DEPTH_TEST);
		gl.glDepthFunc(GL.GL_LEQUAL);
		gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
		gl.glShadeModel(GL.GL_SMOOTH);
		gl.glLightfv(GL.GL_LIGHT1, GL.GL_AMBIENT, AmbLight);
		gl.glLightfv(GL.GL_LIGHT1, GL.GL_DIFFUSE, DifLight);
		gl.glLightfv(GL.GL_LIGHT1, GL.GL_POSITION, LightPos);
		gl.glEnable(GL.GL_LIGHT1);
		gl.glEnable(GL.GL_COLOR_MATERIAL);
		gl.glLightModeli(GL.GL_LIGHT_MODEL_TWO_SIDE, GL.GL_TRUE);
		gl.glEnable(GL.GL_LIGHTING);
		drawable.addMouseListener(this);
		drawable.addMouseMotionListener(this);
	}

	private int createTriangles() {
		mTriangles.clear();
		int triCount = 0;
		for (int i = 0; i < mSize; i++) {
			for (int j = 0; j < mSize; j++) {
				for (int k = 0; k < mSize; k++) {
					polygoniseAndInsert(mGridCells[i][j][k], mIsoLevel);
				}
			}
		}
		return triCount;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.java.games.jogl.GLEventListener#reshape(net.java.games.jogl.GLDrawable,
	 *      int, int, int, int)
	 */
	public void reshape(GLDrawable drawable, int x, int y, int width, int height) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.java.games.jogl.GLEventListener#displayChanged(net.java.games.jogl.GLDrawable,
	 *      boolean, boolean)
	 */
	public void displayChanged(GLDrawable drawable, boolean modeChanged,
			boolean deviceChanged) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.event.MouseListener#mouseClicked(java.awt.event.MouseEvent)
	 */
	public void mouseClicked(MouseEvent e) {
	}

	int prevMouseX;

	int prevMouseY;

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.event.MouseListener#mouseEntered(java.awt.event.MouseEvent)
	 */
	public void mouseEntered(MouseEvent e) {
		// TODO Auto-generated method stub

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.event.MouseListener#mouseExited(java.awt.event.MouseEvent)
	 */
	public void mouseExited(MouseEvent e) {
		// TODO Auto-generated method stub

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.event.MouseListener#mousePressed(java.awt.event.MouseEvent)
	 */
	public void mousePressed(MouseEvent e) {
		prevMouseX = e.getX();
		prevMouseY = e.getY();
		if ((e.getModifiers() & InputEvent.BUTTON2_MASK) == InputEvent.BUTTON2_MASK) {
			mouseMiddleButtonDown = true;
			System.out.println("middle");
		}
	}

	private boolean mouseMiddleButtonDown;

	private int prevMouseZoomY;

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.event.MouseListener#mouseReleased(java.awt.event.MouseEvent)
	 */
	public void mouseReleased(MouseEvent e) {
		if ((e.getModifiers() & InputEvent.BUTTON2_MASK) != InputEvent.BUTTON2_MASK) {
			mouseMiddleButtonDown = false;
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.event.MouseMotionListener#mouseDragged(java.awt.event.MouseEvent)
	 */
	public void mouseDragged(MouseEvent e) {
		int x = e.getX();
		int y = e.getY();
		Dimension size = e.getComponent().getSize();
		
		float thetaY = 360.0f * ((float) (x - prevMouseX) / (float) size.width);
		float thetaX = 360.0f * ((float) (prevMouseY - y) / (float) size.height);

		prevMouseX = x;
		prevMouseY = y;

		MillingSimulator.xrot += thetaX;
		MillingSimulator.yrot += thetaY;
	}

	public void mouseMoved(MouseEvent e) {
	}

	public void windowActivated(WindowEvent e) {
	}

	public void windowClosed(WindowEvent e) {
	}

	public void windowClosing(WindowEvent e) {
		new Thread(new Runnable() {
			public void run() {
				animator.stop();
				System.exit(0);
			}
		}).start();
		System.out.println("minx:" + MillingSimulator.minx);
		System.out.println("miny:" + MillingSimulator.miny);
		System.out.println("minz:" + MillingSimulator.minz);

		System.out.println("maxx:" + MillingSimulator.maxx);
		System.out.println("maxy:" + MillingSimulator.maxy);
		System.out.println("maxz:" + MillingSimulator.maxz);		
	}

	public void windowDeactivated(WindowEvent e) {
	}

	public void windowDeiconified(WindowEvent e) {
	}

	public void windowIconified(WindowEvent e) {
	}

	public void windowOpened(WindowEvent e) {
	}
}